#!/bin/bash
#
# (This file was generated by PluginGenerator version 0.8.6)
# This script starts the Renew GUI and the application in this folder.
#
# Assumptions made by this script:
# - The java executables are included in the shell's search path.
# - All neccessary plugins are installed.
# - The variables below have been configured properly.
# - (A rmiregistry process has been started on the local host.)
#
# $Id$


# -------------------------------------------------------------------------
#                                                         PARSE COMMANDLINE
# -------------------------------------------------------------------------
customprops=()
debugeclipseoptions=()
jprofileoptions=()
navwsoptions=()
navfilesoptions=()

while [ "X-" == `echo "X$1" | cut -c1-2` ]; do
    case "$1" in
    "-v"|"--verbose")
        verbose=true			# used in configuration section
        echo "OPTIONS: Verbose"
        shift
        ;;
    "-a"|"--ant")
        runant=true
	echo "OPTIONS: Run Ant first"
	shift
	;;
    "-n"|"--nonav")
        nonavconfig=true
        echo "OPTIONS: run the startscript "
        shift
        ;;
    "-r"|"--run")
        runscript=true
        echo "OPTIONS: run the startscript "
        shift
        ;;
    "-d"|"--debug-eclipse")
        debugeclipse=true		# used in configuration section
        echo "OPTIONS: debug-eclipse"
        shift
        ;;
    "-h"|"--help")
        showhelp=true
        break
        ;;
    "-")
        break
        ;;
    *)
        echo "$0: unknown option: $1"
        showhelp=true
        break
        ;;
    esac
done

if [ "${showhelp}" = "true" ]
then
  echo "   This is the start.sh help message.";
  echo "   Start Application in folder FAFormalism with "
  echo "    'bash testing/start.sh [options] [drawings...]'.";
  echo "   Options:";
  echo "    --verbose       -v  Be more verbose.";
  echo "    --ant           -a  Run 'ant dist' before starting the application.";
  echo "    --nonav         -n  do _not_ override user set navigator configuration.";
  echo "    --run           -r  Initially run script 'startscript'.";
  echo "    --debug-eclipse -d  Start a debugging session with the remote debugger of eclipse.";
  echo "                        Further instructions will be given.";
  echo "    -               -   End option processing, all following arguments are interpreted"
  echo "                        as drawing file names."
  echo "    --help          -h  Show this message.";
  exit 1;
fi


# -------------------------------------------------------------------------
#                                                     CONFIGURATION - BEGIN
# -------------------------------------------------------------------------




renewdist="$(dirname "$0")/../../dist"
if [ ! -d "$renewdist" ]; then
  renewdist=/local/tgi/renew2.2
  if [ ! -d "$renewdist" ];then
    renewdist="$(dirname "$0")/../../../dist"
    if [ ! -d "$renewdist" ];then     
      echo "Error: Renew installation directory does not exist."
      echo "       Please compile or configure."
      exit 1
    fi
  fi
fi

if [ "$verbose" = "true" ];then
  echo "Using Renew dist folder in $renewdist"
fi

pluginlocation=$(dirname "$0")"/../.."

falocation="$pluginlocation/FA"
sampleslocation="$falocation/samples/"

if [ ! -d "$falocation" ];then     
  echo "Error: FA plugin directory does not exist."
  echo "       Please update your Renew repository."
  exit 1
fi

if [ "$verbose" = "true" ];then
  echo "Using plugin folder in $pluginlocation"
  echo "Using FA folder in $falocation"
fi


# if the commandline option --debug-eclipse is set augment options so that
# underlying Java VM is ready for debugging interaction with Eclipse
# (and every other program running on localhost)
# also see:  https://tgiprojekte.informatik.uni-hamburg.de/projects/paose/wiki/Eclipse#Remote-Debug-Modus-for-Java-Files

if [ "${debugeclipse}" = "true" ]
then
  debugeclipseoptions=("-Xdebug" "-Xnoagent" "-Djava.compiler=NONE" \
                       "-Xrunjdwp:transport=dt_socket,address=8787,server=y,suspend=y")
fi


UNAME=`uname |cut -d _ -f 1`

if [ "$verbose" = "true" ]; then
  echo "customprops: ${customprops[@]}"
fi

if [ "${runscript}" = "true" ]
then
  initialcommand="script  $(dirname "$0")/startscript"
  initialnet=""
  #initialnet="$sampleslocation/communication/refnet-calls-aut/uplink.fa"
else
  initialcommand="gui"
  initialnet="$sampleslocation/inscriptionTypes.fa"
fi

javaexecutable="$(which java)"
if [ ! "$JAVA_HOME" = "" ]
then
  javaexecutable="${JAVA_HOME}/bin/java"
fi

# -------------------------------------------------------------------------
#                                                       CONFIGURATION - END
# -------------------------------------------------------------------------

# Run ant before anything else happens, if requested.
if [ "${runant}" == "true" ]
then
    pushd "${pluginlocation}"
    ant dist FA
    popd
fi


# path for automatic NETPATH generation or direct opening
pluginSourcePath="${pluginlocation}/FA/src"
pluginClassesPath="${pluginlocation}/FA/build/classes"


# Setup the classpath: pluginSourcePath, all Renew jars.
CLASSPATH="$pluginSourcePath"
CLASSPATH="$CLASSPATH:${renewdist}/loader.jar"
#for jar in $(find "${renewdist}/plugins" -name "*.jar")
#do
#    CLASSPATH="${CLASSPATH}:${jar}"
#done
export CLASSPATH

# Setup Plugin locations:
PLUGINLOCATIONS="${renewdist}"

# Setup net load path: Include all samples subfolders 
NETPATH="${pluginlocation}"
for dir in $(find "${sampleslocation}" -mindepth 1 -type d)
do
    NETPATH="${NETPATH}:${dir}"
done
export NETPATH 


if [ "$UNAME" = "CYGWIN" ]
then
    CLASSPATH=$(cygpath -wp "$CLASSPATH")
    NETPATH=$(cygpath -wp "$NETPATH")
    PLUGINLOCATIONS=$(cygpath -wp "$PLUGINLOCATIONS")
fi

SCRIPTPATH="$( cd "$( echo "${BASH_SOURCE[0]%/*}" )" && pwd )" 
parentdir="$(dirname "$SCRIPTPATH")"
PROJECT_DIR="$(dirname "$parentdir")"
PROJECT_NAME=$(basename ${PROJECT_DIR})
WORK_SPACE="$(dirname "$PROJECT_DIR")"
#echo "SCRIPT PATH ${SCRIPTPATH} / PROJECT NAME ${PROJECT_NAME}"
#echo "Project DIR ${PROJECT_DIR} / WORK SPACE ${WORK_SPACE}"
#exit 1

if [ "$nonavconfig" != "true" ] ; then
  navwsoptions="-Dde.renew.navigator.workspace=${WORK_SPACE}" 
  navfilesoptions="-Dde.renew.navigator.filesAtStartup=${PROJECT_NAME}/FAFormalism;Mulan/MulanAgent"
fi

customprops+=("-Dde.renew.classReinit=true")

# Print the configuration for debugging purposes
if [ "$verbose" = "true" ] ; then
echo
echo "Java executable: ${javaexecutable}"
echo
echo "CLASSPATH=${CLASSPATH}"
echo
echo "NETPATH=${NETPATH}"
echo
echo "Property options: ${propertyoptions[@]}"
echo "Custom set properties: ${customprops[@]}"
echo "Eclipse Debug options: ${debugeclipseoptions[@]}"
fi

# Print hint for poor user trying to debug
if [ "${debugeclipse}" = "true" ]
then
    echo
    echo
    echo
    echo "You are about to start Renew (the Java VM to be more precise) with remote DEBUG settings."
    echo
    echo
    echo "RENEW WILL *NOT* CONTINUE UNLESS YOU CONNECT YOUR ECLIPSE TO IT."
    echo
    echo
    echo "For the gory details please see:"
    echo "  https://tgiprojekte.informatik.uni-hamburg.de/projects/paose/wiki/Eclipse#Remote-Debug-Modus-for-Java-Files"
    echo
fi

# Start Renew
echo "Starting Renew..."
[ "$verbose" = "true" ] && set -x
"${javaexecutable}" "${debugeclipseoptions[@]}" "${dboptions[@]}" "${propertyoptions[@]}" \
    "${jprofileoptions[@]}" \
    "${customprops[@]}" \
    "-Dde.renew.access.adaptor=${adaptor}" \
    "-Dde.renew.remote.enable=true" \
    "-DpluginLocations=${PLUGINLOCATIONS}" \
    "-Dde.renew.agent.platform.useCentralDF=" \
    "-Dde.renew.agent.ace.start-agent.ps=" \
    "-Dde.renew.netPath=${NETPATH}" \
    "-Dde.renew.classPath=${pluginClassesPath}" \
    "${navwsoptions[@]}" \
    "${navfilesoptions[@]}" \
    ${JAVA_OPTS} \
    de.renew.plugin.Loader ${initialcommand} \
        ${initialnet} \
        "$@"
