/*
 * Created on Sep 15, 2005
 *
 */
package de.renew.fa.service;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatAbstract;

import de.renew.fa.XFAFileFilter;

import de.renew.util.StringUtil;

import java.io.File;
import java.io.FileInputStream;

import java.net.URL;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * Defines the import XFA format for a finite automata drawing (<code>FADrawing</code>).
 * @see de.renew.fa.service.XFAFormat
 * @author cabac
 *
 */
public class XFAImportFormat extends ImportFormatAbstract
                implements ImportFormat {
    public XFAImportFormat() { //String name, FileFilter fileFilter) {
        super("XFA", new XFAFileFilter());
    }

    /**
     * Returns a list of all drawings in the file.
     *
     * @require file != null
     * @ensure result != null
     * @param file - The XFA file to be imported.
     * @return list of all imported drawings.
     * @throws Exception,
     *             is thrown in case of failure during import of file.
     */
    protected List<Drawing> importFile(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }

        FileInputStream stream = new FileInputStream(new File(file.getFile()));
        XFAFormat format = new XFAFormat();
        List<Drawing> result = format.parse(stream,
                        StringUtil.getFilename(file.getPath()));
        stream.close();
        return result;
    }

    /**
     * (non-Javadoc)
     *
     * @see CH.ifa.draw.io.importFormats.ImportFormat#importFiles(java.net.URL[])
     */
    @Override
    public List<Drawing> importFiles(URL[] paths) throws Exception {
        List<Drawing> list = new ArrayList<Drawing>(paths.length);
        for (int i = 0; i < paths.length; i++) {
            URL url = paths[i];
            list.addAll(importFile(url));
        }
        return list;
    }
}