/*
 * Created on Sep 13, 2005
 *
 */
package de.renew.fa;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.io.SimpleFileFilter;

import de.renew.fa.figures.FAStateFigure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;

import java.util.HashSet;


/**
 * This {@link Drawing} is a container of arbitrary figures, but it
 * only supports functionality for finite automaton constructs.
 */
public class FADrawing extends CPNDrawing implements LayoutableDrawing {
    static final long serialVersionUID = -4229673070089970973L;
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(FADrawing.class);

    /**
     * Container for fa {@link java.io.FileFilter}.
     */
    private static FilterContainer filterContainer;

    /**
     * Gets the {@link java.io.FileFilter}s of FADrawings.
     *
     * @return  the FileFilter for FADrawings
     */
    static public FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer(new FAFileFilter());
        } else {
            return filterContainer;
        }
    }

    /**
     * Constructs an empty FADrawing.
     */
    public FADrawing() {
        super();
    }

    @Override
    synchronized public void fillInGraph(GraphLayout layout) {
        logger.debug("fillInGraph(GraphLayout) called with " + layout);
        FigureEnumeration k = figures();

        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();

            // if (f instanceof TransitionFigure || f instanceof PlaceFigure) {
            if (f instanceof FAStateFigure || (f instanceof TextFigure
                            && ((TextFigure) f).parent() == null)) {
                layout.addNode(f);

                // } else if (f instanceof ArcConnection) {
            } else if (f instanceof ConnectionFigure) {
                layout.addEdge((ConnectionFigure) f, 20);
            }
            logger.debug("added " + f);
        }
    }

    @Override
    public String getDefaultExtension() {
        return getDefaultFileFilter().getExtension();
    }

    @Override
    public SimpleFileFilter getDefaultFileFilter() {
        return getFilterContainer().getDefaultFileFilter();
    }

    @Override
    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return getFilterContainer().getExportFileFilters();
    }

    @Override
    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return getFilterContainer().getImportFileFilters();
    }

    @Override
    public String getWindowCategory() {
        return "Finite Automata";
    }
}