package de.renew.console;

import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;

import de.renew.console.completer.CompleterComposition;
import de.renew.console.completer.DrawingsCompleter;
import de.renew.console.completer.FirstWhitespaceArgumentDelimiter;
import de.renew.console.completer.LocationsCompleter;
import de.renew.console.completer.PluginCompleter;
import de.renew.console.completer.PropertyCompleter;
import de.renew.console.completer.RenewArgumentCompleter;

import de.renew.plugin.CommandsListener;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;
import de.renew.plugin.command.CLCommand;

import de.renew.util.StringUtil;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

import java.net.URL;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.CountDownLatch;


/*
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version 0.4)
 * Representative for the Console plug-in.
 */


/**
 * This plugin provides an interactive command line user interface.
 *
 * @author Joern Schumacher
 * @author Michael Duvigneau
 * @author Lawrence Cabac
 * @author David Mosteller
 */
public class ConsolePlugin extends PluginAdapter implements CommandsListener {
    private static final String COLOR_PROP_NAME = "de.renew.console.color";
    private static final String DRAWING_NAMES = "drawingNames";
    private static final String PROPERTY_NAMES = "propertyNames";
    private static final String LOCATION_NAMES = "locationNames";
    private static final String PLUGIN_NAMES = "pluginNames";
    private static final String FILE_NAMES = "fileNames";
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(ConsolePlugin.class);
    public static final String DONT_PROP_NAME = "de.renew.console.dont";
    public static final String ALIVE_PROP_NAME = "de.renew.console.keepalive";
    private boolean coloredPrompt = false;
    private PromptThread _promptThread;
    private boolean blockingState = false;
    private Map<String, Completer> completers = new HashMap<String, Completer>();
    private CountDownLatch latch;
    private boolean promtThreadReady = false;
    private SoftDependency chDependency;

    public ConsolePlugin(URL url) throws PluginException {
        super(url);
    }

    public ConsolePlugin(PluginProperties props) {
        super(props);
    }

    @Override
    public synchronized void init() {
        // create a command prompt
        boolean startPrompt = !getProperties().getBoolProperty(DONT_PROP_NAME);
        if (startPrompt) {
            this.latch = new CountDownLatch(1);
            prompt();
            setBlockingState(getProperties().getBoolProperty(ALIVE_PROP_NAME));
            PluginManager pm = PluginManager.getInstance();
            pm.addCommandListener(this);
            coloredPrompt = getProperties().getBoolProperty(COLOR_PROP_NAME);

            // add commands that have been added to the pm before
            for (Entry<String, CLCommand> entry : pm.getCLCommands()
                            .entrySet()) {
                String commandName = entry.getKey();
                CLCommand command = entry.getValue();
                commandAdded(commandName, command);
            }
            pm.addCLCommand("keepalive", new BlockingPromptCommand());
        } else {
            logger.debug("ConsolePlugin: " + DONT_PROP_NAME
                            + " is set to true. Not prompting.");
        }
        chDependency = new SoftDependency(this, "ch.ifa.draw",
                        "de.renew.console.CHDependencyListener");
    }

    @Override
    public synchronized boolean cleanup() {
        if (_promptThread != null) {
            logger.debug("shutting down prompt thread " + _promptThread);
            _promptThread.setStop();
            PluginManager.getInstance().removeCLCommand("keepalive");
            _promptThread = null;
        }
        PluginManager pm = PluginManager.getInstance();
        pm.removeCLCommand("keepalive");
        pm.removeCLCommand("reinit");
        pm.removeCommandListener(this);

        //NOTICEnull
        if (chDependency != null) {
            chDependency.discard();
            chDependency = null;
        }
        return true;
    }

    private void prompt() {
        _promptThread = new PromptThread();
        _promptThread.start();
    }

    public synchronized void setBlockingState(boolean newState) {
        if (newState != blockingState) {
            blockingState = newState;
            if (blockingState) {
                registerExitBlock();
            } else {
                registerExitOk();
            }
        }
    }

    /**
     * This class represents a thread waiting for input.
     * If a string is entered, the thread compares it
     * to the available commands of the manager; if one is
     * available, its execute method is invoked.
     */
    private class PromptThread extends Thread {
        private static final String HISTORY_PROPS = "history.props";
        private boolean _stop = false;
        private ConsoleReader reader;
        private File prefsFile = null;
        private CompleterComposition ac = new CompleterComposition();

        public PromptThread() {
            super("Plugin-Prompt-Thread");
            File dotRenew = PluginManager.getPreferencesLocation();
            prefsFile = new File(dotRenew, HISTORY_PROPS);
        }

        @Override
        public void run() {
            logger.debug("Prompt thread running.");
            _stop = false;
            try {
                //boolean color = true;
                reader = new ConsoleReader();
                CompletionHandler completionHandler = reader
                                .getCompletionHandler();
                if (completionHandler instanceof CandidateListCompletionHandler) {
                    ((CandidateListCompletionHandler) completionHandler)
                                    .setPrintSpaceAfterFullCompletion(false);
                }
                reader.setPrompt(getPrompt());
                FileHistory history = new FileHistory(prefsFile);
                reader.setHistory(history);
                reader.addCompleter(ac);

                String line = null;
                PrintWriter out = new PrintWriter(reader.getOutput());
                ConsolePlugin.this.latch.countDown(); // prompt thread is ready
                try {
                    line = reader.readLine();
                } catch (IllegalArgumentException e) {
                    logger.error("Illegal agrument: " + e.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug(ConsolePlugin.PromptThread.class
                                        .getSimpleName() + ": " + e);
                    }
                }
                while (!_stop && line != null) {
                    if (logger.isDebugEnabled()) {
                        if (coloredPrompt) {
                            logger.debug("\u001B[33m=>\u001B[0m\"" + line
                                            + "\"");

                        } else {
                            logger.debug("=>\"" + line + "\"");
                        }
                    }
                    out.flush();

                    try {
                        Map<String, CLCommand> commands = PluginManager
                                        .getInstance().getCLCommands();

                        String[] cmds = line
                                        .split(PluginManager.COMMAND_SEPERATOR);
                        for (String cmd : cmds) {
                            cmd = cmd.trim();
                            String[] cl = StringUtil.splitStringWithEscape(cmd);
                            if (cl.length == 0) {
                                continue;
                            }
                            CLCommand c = commands.get(cl[0]);
                            if (c == null) {
                                System.out.println("unknown command.");
                            } else {
                                String[] nc = new String[cl.length - 1];
                                for (int i = 0; i < nc.length; i++) {
                                    nc[i] = cl[i + 1];
                                }
                                c.execute(nc, System.out);
                            }
                        }
                    } catch (RuntimeException e) {
                        logger.error("PromptThread: an exeption occurred: "
                                        + e);
                        logger.error(e.getMessage(), e);
                    }
                    try {
                        // ensure that reader is in definite state each time
                        // allows us the return from Ctrl-Z / fg
                        try {
                            reader.getTerminal().init();
                        } catch (Exception e) {
                        }
                        line = reader.readLine();
                    } catch (IllegalArgumentException e) {
                        logger.error("Illegal agrument: " + e.getMessage());
                        if (logger.isDebugEnabled()) {
                            logger.debug(ConsolePlugin.PromptThread.class
                                            .getSimpleName() + ": " + e);
                        }
                    }
                }
                System.out.println("exiting 2");
            } catch (ThreadDeath death) {
                logger.debug("Prompt thread exiting!");
            } catch (IOException e1) {
                logger.error(e1.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(ConsolePlugin.PromptThread.class
                                    .getSimpleName() + ": " + e1);
                }
            }

            // We do not try to close the reader because other threads
            // might still want to access the System input stream.
            setBlockingState(false);
            System.out.println("exiting 3");
        }

        private String getPrompt() {
            if (coloredPrompt) {
                return "\u001B[34mRenew > \u001B[0m";
            } else {
                return "Renew > ";
            }
        }

        protected void setStop() {
            FileHistory history = (FileHistory) reader.getHistory();
            try {
                history.flush();
            } catch (IOException e) {
                logger.error(e.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(ConsolePlugin.PromptThread.class
                                    .getSimpleName()
                                    + ": could not save prompt history" + e);
                }
            }
            _stop = true;
            interrupt();
        }
    }

    private class BlockingPromptCommand implements CLCommand {
        @Override
        public void execute(String[] args, PrintStream response) {
            if (args.length == 0) {
                if (blockingState) {
                    response.println("Prompt will keep plugin system alive.");
                } else {
                    response.println(
                                    "Prompt will not prevent plugin system from automatic termination.");
                }
            } else if ("on".equals(args[0])) {
                setBlockingState(true);
                response.println("Prompt will keep plugin system alive.");
            } else if ("off".equals(args[0])) {
                setBlockingState(false);
                response.println(
                                "Prompt will not prevent plugin system from automatic termination.");
            } else {
                response.println(
                                "Controls the keep-alive feature of the Renew Prompt plugin.\n"
                                                + "Arguments:\n"
                                                + " - \"on\" prevents the plugin system from automatic termination.\n"
                                                + " - \"off\" allows automatic termination as long as no other plugin prevents it.\n"
                                                + " - no argument displays the current keep-alive mode.");
            }
        }

        @Override
        public String getDescription() {
            return "controls the keep-alive feature of the Renew Prompt plugin.";
        }

        /**
         * @see de.renew.plugin.command.CLCommand#getArguments()
         */
        @Override
        public String getArguments() {
            return null;
        }
    }

    @Override
    public void commandAdded(String name, CLCommand command) {
        if (logger.isDebugEnabled()) {
            logger.debug("[" + ConsolePlugin.class.getSimpleName()
                            + "]: Command added: " + name + " "
                            + command.getClass().getSimpleName());
        }
        String arguments = command.getArguments();
        String[] argumentsArray = null;
        if (arguments != null) {
            // replace multiple whitespaces with a single one and split 
            argumentsArray = arguments.replaceAll(" +", " ").split(" ");
        }
        Completer completer = getCompleterForCommand(name, argumentsArray);

        // wait until thread is initialized; shouln't take too long
        if (!this.promtThreadReady) {
            try {
                logger.debug("[" + ConsolePlugin.class.getSimpleName()
                                + "]: Waiting for Prompt thread.");
                this.latch.await();
                this.promtThreadReady = true;
                logger.debug("[" + ConsolePlugin.class.getSimpleName()
                                + "]: Prompt thread ready.");
            } catch (InterruptedException e) {
            }
        }
        _promptThread.ac.addCompleter(completer);
        completers.put(name, completer);
    }

    @Override
    public void commandRemoved(String name) {
        if (_promptThread != null && _promptThread.ac != null) {
            _promptThread.ac.removeCompleter(completers.remove(name));
        }
    }

    /**
     * creates a completer for the given command and its arguments. The
     * arguments are already separated, but each argument may use a special
     * syntax to denote optional, alternative or recurring arguments (see
     * {@link de.renew.plugin.command.CLCommand#getArguments()} for details)
     *
     * @param commandName the name of the command
     * @param arguments the arguments for the command as array
     * @return a completer for completion of the command and the arguments
     */
    private Completer getCompleterForCommand(String commandName,
                                             String[] arguments) {
        /*
         * This method builds a completer which consists of several linked
         * subcompleters. Each argument has its own completer, which delegates
         * the next argument to the next completer. With this behavior it is
         * possible to skip optional arguments by delegating the next argument
         * to the next completer but one or to repeat certain arguments.
         * The completer is built from back to front.
         */
        Completer completer = new NullCompleter();
        if (arguments != null) {
            Completer followUpCompleter = new NullCompleter();
            for (int i = arguments.length - 1; i >= 0; i--) {
                String arg = arguments[i];
                Completer completerForArgument;

                // enclosing square brackets [] and optionally a terminating * 
                boolean optional = arg.matches("\\[.*\\]\\*?");

                // enclosing parentheses () and optionally a terminating *
                boolean alternative = arg.matches("\\(.*\\)\\*?");
                boolean loop = false;

                // argument may contain multiple alternatives separated by | 
                if (optional || alternative) {
                    if (arg.matches(".*\\*")) {
                        // cut of enclosing brackets ()/[] and terminal *
                        arg = arg.substring(1, arg.length() - 2);
                        loop = true;
                    } else {
                        // cut of enclosing brackets ()/[]
                        arg = arg.substring(1, arg.length() - 1);
                    }
                    String[] argSplit = arg.split("\\|");
                    List<String> strings = new ArrayList<String>();
                    List<Completer> completers = new ArrayList<Completer>();
                    for (String s : argSplit) {
                        if (isKeyword(s)) {
                            completers.add(getCompleterForKeyword(s));
                        } else {
                            strings.add(s + " ");
                        }
                    }
                    if (strings.size() > 0) {
                        completers.add(new StringsCompleter(strings));
                    }
                    completerForArgument = new CompleterComposition(completers);
                }
                // argument is just a single word 
                else {
                    if (isKeyword(arg)) {
                        completerForArgument = getCompleterForKeyword(arg);
                    } else {
                        completerForArgument = new StringsCompleter(arg + " ");
                    }
                }

                if (loop) {
                    // use completerForArgument for the argument and delegate 
                    // the next argument to the followUpCompleter. Since the 
                    // argument may be repeated, the next argument should 
                    // alternatively be delegated to the completerForArgument 
                    // again and afterwards to the followUpCompleter. 
                    CompleterComposition followUpCompleterWithBackwardsOption = new CompleterComposition(
                                    followUpCompleter);
                    completer = new RenewArgumentCompleter(
                                    new FirstWhitespaceArgumentDelimiter(),
                                    completerForArgument,
                                    followUpCompleterWithBackwardsOption);
                    followUpCompleterWithBackwardsOption
                                    .addCompleter(completer);

                } else {
                    // use completerForArgument for the argument and delegate 
                    // the next argument to the followUpCompleter. 
                    completer = new RenewArgumentCompleter(
                                    new FirstWhitespaceArgumentDelimiter(),
                                    completerForArgument, followUpCompleter);
                }

                if (optional) {
                    // the argument may be skipped, so use the built completer 
                    // or directly delegate to the followUpCompleter 
                    completer = new AggregateCompleter(completer,
                                    followUpCompleter);
                }
                followUpCompleter = completer;
            }
        }

        // build a completer, which completes the command name and delegates 
        // the arguments to the previously built completer.   
        return new RenewArgumentCompleter(
                        new FirstWhitespaceArgumentDelimiter(),
                        new StringsCompleter(commandName + " "), completer);
    }

    private Completer getCompleterForKeyword(String keyword) {
        Completer result;
        if (keyword.equals(FILE_NAMES)) {
            result = new FileNameCompleter();
        } else if (keyword.equals(PLUGIN_NAMES)) {
            result = new PluginCompleter();
        } else if (keyword.equals(LOCATION_NAMES)) {
            result = new LocationsCompleter();
        } else if (keyword.equals(PROPERTY_NAMES)) {
            result = new PropertyCompleter();
        } else if (keyword.equals(DRAWING_NAMES)) {
            result = new DrawingsCompleter();
        } else {
            result = new NullCompleter();
        }
        return result;
    }

    private boolean isKeyword(String candidate) {
        return (candidate.equals(FILE_NAMES))
                        || (candidate.equals(PLUGIN_NAMES))
                        || (candidate.equals(LOCATION_NAMES))
                        || (candidate.equals(PROPERTY_NAMES))
                        || (candidate.equals(DRAWING_NAMES));
    }
}