/*
 * @(#)SelectAreaTracker.java 5.1
 *
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import java.util.Vector;


/**
 * SelectAreaTracker implements a rubberband selection of an area.
 */
public class SelectAreaTracker extends AbstractTool {
    private Rectangle fSelectGroup;

    // If we use some zooming factor, the draw selection rectangle doesn't match with the actual selection
    // Therefore we have to differentiate the two.
    private Rectangle fVisualSelectGroup;
    private Point fVisualAnchor;

    public SelectAreaTracker(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        // use event coordinates to supress any kind of
        // transformations like constraining points to a grid
        super.mouseDown(e, x, y);
        fVisualAnchor = new Point(e.getX(), e.getY());
        visualRubberBand(fVisualAnchor.x, fVisualAnchor.y, fVisualAnchor.x,
                        fVisualAnchor.y);

        selectionRubberBand(fAnchorX, fAnchorY, fAnchorX, fAnchorY);

    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        eraseRubberBand();
        visualRubberBand(fVisualAnchor.x, fVisualAnchor.y, e.getX(), e.getY());
        selectionRubberBand(fAnchorX, fAnchorY, x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        eraseRubberBand();
        selectGroup(e.isShiftDown());
    }

    private void visualRubberBand(int x1, int y1, int x2, int y2) {
        fVisualSelectGroup = new Rectangle(new Point(x1, y1));
        fVisualSelectGroup.add(new Point(x2, y2));
        drawXORRect(fVisualSelectGroup);
    }

    private void selectionRubberBand(int x1, int y1, int x2, int y2) {
        fSelectGroup = new Rectangle(new Point(x1, y1));
        fSelectGroup.add(new Point(x2, y2));

    }

    private void eraseRubberBand() {
        drawXORRect(fVisualSelectGroup);
    }

    private void drawXORRect(Rectangle r) {
        Graphics g = view().getGraphics();
        drawXORRect(r, g);
    }

    private void drawXORRect(Rectangle r, Graphics g) {
        g.setXORMode(view().getBackground());
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void selectGroup(boolean toggle) {
        FigureEnumeration k = drawing().figuresReverse();
        Vector<Figure> concernedFigures = new Vector<Figure>();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle r2 = figure.displayBox();
            if (fSelectGroup.contains(r2.x, r2.y) && fSelectGroup
                            .contains(r2.x + r2.width, r2.y + r2.height)) {
                concernedFigures.addElement(figure);
            }
        }
        if (toggle) {
            view().toggleSelectionAll(concernedFigures);
        } else {
            view().addToSelectionAll(concernedFigures);
        }
    }

    /**
     * Refreshes the rubber band, if overdrawn by the repaint
     * event leading to this method call.
     **/
    @Override
    public void draw(Graphics g) {
        if (fVisualSelectGroup != null) {
            drawXORRect(fVisualSelectGroup, g);
        }
    }
}