/*
 * @(#)DrawingEditor.java 5.1
 *
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.DrawingViewContainer;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.UndoRedoManager;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;


public class NullDrawingEditor implements DrawingEditor {
    public static NullDrawingEditor INSTANCE = new NullDrawingEditor();

    private NullDrawingEditor() {
    }

    @Override
    public DrawingView view() {
        return NullDrawingView.INSTANCE;
    }

    @Override
    public DrawingView previousView() {
        return NullDrawingView.INSTANCE;
    }

    @Override
    public Drawing drawing() {
        return NullDrawing.INSTANCE;
    }

    @Override
    public Tool tool() {
        return NullTool.INSTANCE;
    }

    @Override
    public Tool defaultTool() {
        return null;
    }

    @Override
    public void setStickyTools(boolean sticky) {
    }

    @Override
    public boolean isStickyTools() {
        return false;
    }

    @Override
    public void dispatchEvent(KeyEvent evt) {
    }

    @Override
    public Image getIconImage() {
        return null;
    }

    @Override
    public void toolDone() {
    }

    @Override
    public void selectionChanged(DrawingView view) {
    }

    @Override
    public void menuStateChanged() {
    }

    @Override
    public void showStatus(String string) {
    }

    /**
     *
     * @param drawing
     * @return
     */
    public CH.ifa.draw.application.DrawingViewFrame showDrawingViewFrame(Drawing drawing) {
        // No such frame available.
        return null;
    }

    @Override
    public void drawingViewContainerActivated(DrawingViewContainer viewContainer) {
    }

    @Override
    public void drawingViewContainerClosing(DrawingViewContainer viewContainer) {
    }

    @Override
    public void prepareUndoSnapshot() {
    }

    @Override
    public void commitUndoSnapshot() {
    }

    @Override
    public void prepareAccumulatedUndoSnapshot() {
    }

    @Override
    public void triggerAccumulatedUndoSnapshot() {
    }

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return null;
    }

    @Override
    public void setCurrentDrawing(DrawingViewContainer dvc) {
    }

    @Override
    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(0, 0);
    }
}