/*
 * @(#)Drawing.java 5.1
 *
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureEnumeration;

import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

import java.io.File;
import java.io.Serializable;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;


public class NullDrawing extends FigureChangeAdapter
                implements Drawing, Storable, Serializable {
    public static NullDrawing INSTANCE = new NullDrawing();

    // I cannot make the constructor private, because I must
    // be storable.
    public NullDrawing() {
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public File getFilename() {
        return null;
    }

    @Override
    public void setFilename(File filename) {
    }

    // Always claim to backuped, so that no backups are ever made.
    @Override
    public boolean getBackupStatus() {
        return true;
    }

    @Override
    public void setBackupStatus(boolean status) {
    }

    @Override
    public void release() {
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle();
    }

    @Override
    public FigureEnumeration figures() {
        return new FigureEnumerator(new Vector<Figure>());
    }

    @Override
    public FigureEnumeration figuresReverse() {
        return figures();
    }

    @Override
    public Figure findFigure(int x, int y) {
        return null;
    }

    @Override
    public Figure findFigure(Rectangle r) {
        return null;
    }

    @Override
    public Figure findFigureWithout(int x, int y, Figure without) {
        return null;
    }

    @Override
    public Figure findFigure(Rectangle r, Figure without) {
        return null;
    }

    @Override
    public Figure findFigureInside(int x, int y) {
        return null;
    }

    @Override
    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        return null;
    }

    @Override
    public void addDrawingChangeListener(DrawingChangeListener listener) {
    }

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener listener) {
    }

    @Override
    public Enumeration<DrawingChangeListener> drawingChangeListeners() {
        return new Vector<DrawingChangeListener>().elements();
    }

    @Override
    public void checkDamage() {
    }

    @Override
    public Figure add(Figure figure) {
        return figure;
    }

    @Override
    public Drawing add(Drawing drawing) {
        return drawing;
    }

    @Override
    public Drawing add(Drawing drawing, int x, int y) {
        return drawing;
    }

    @Override
    public void addAll(Vector<? extends Figure> newFigures) {
    }

    @Override
    public Figure remove(Figure figure) {
        return figure;
    }

    @Override
    public Figure orphan(Figure figure) {
        return figure;
    }

    @Override
    public void orphanAll(Vector<? extends Figure> newFigures) {
    }

    @Override
    public void removeAll(Vector<? extends Figure> figures) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void replace(Figure figure, Figure replacement) {
    }

    @Override
    public void sendToBack(Figure figure) {
    }

    @Override
    public void bringToFront(Figure figure) {
    }

    @Override
    public void draw(Graphics g) {
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public void write(StorableOutput so) {
    }

    @Override
    public void read(StorableInput si) {
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void clearModified() {
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(0, 0);
    }

    @Override
    public String getWindowCategory() {
        return "<BUG> Null drawings";
    }

    //------------------------------------------------------------------------
    @Override
    public SimpleFileFilter getDefaultFileFilter() {
        return new NoFileFilter();
    }

    /* (non-Javadoc)
    * @see CH.ifa.draw.framework.Drawing#getFileFilters()
    */
    @Override
    public HashSet<SimpleFileFilter> getImportFileFilters() {
        HashSet<SimpleFileFilter> hs = new HashSet<SimpleFileFilter>();

        return hs;
    }

    @Override
    public HashSet<SimpleFileFilter> getExportFileFilters() {
        HashSet<SimpleFileFilter> hs = new HashSet<SimpleFileFilter>();

        //hs.add(getDefaultFileFilter());
        return hs;
    }

    /* (non-Javadoc)
    * @see CH.ifa.draw.framework.Drawing#getDefaultExtension()
    */
    @Override
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isStorable() {
        return false;
    }
}