package de.renew.rnrg.elements;

import de.renew.net.NetInstance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;


public class CurryNode extends Node {
    private static final long serialVersionUID = 0L;
    private final NetInstance instance;

    public CurryNode(final NetInstance instance) {
        this.instance = instance;
        edges = new HashSet<Edge>();
    }

    public void addEdge(String name, String description, Node targetNode) {
        edges.add(new InscribedEdge(name, description, targetNode));
        targetNode.addPredecessor(this);
    }

    public void addEdge(Node targetNode) {
        edges.add(new Edge(targetNode));
        targetNode.addPredecessor(this);
    }

    @Override
    public Collection<? extends NetInstance> getNetInstances() {
        return Collections.singleton(instance);
    }

    @Override
    public NetInstance getRootNetInstance() {
        return instance;
    }

    @Override
    public long getDepth() {
        // TODO Auto-generated method stub
        return 0;
    }
}