package de.renew.net;

import de.renew.net.event.PlaceEvent;

import java.io.Serializable;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;


public class CurryPlaceInstance extends PlaceInstance implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * Representation of a token in a Curry CPN simulation.
     * Please note that two CurryToken objects created for the same string are not equal.
     * A CurryToken object is only equal to itself.
     */
    private static class CurryToken implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String str;

        CurryToken(final String str) {
            this.str = str;
        }

        @Override
        public String toString() {
            return str;
        }
    }

    private Map<CurryToken, Integer> marking = new HashMap<CurryToken, Integer>();

    CurryPlaceInstance(NetInstance netInstance, Place place) {
        super(netInstance, place);
    }

    public void resetMarking() {
        lock.lock();
        try {
            marking.clear();
        } finally {
            lock.unlock();
        }
    }

    public void addToken(final String str, final int count) {
        lock.lock();
        try {
            marking.put(new CurryToken(str), count);
        } finally {
            lock.unlock();
        }
    }

    public void notifyListeners() {
        PlaceEvent te = new PlaceEvent(netInstance.getInstance(place));
        listeners.markingChanged(te);
        place.getListenerSet().markingChanged(te);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Set<Object> getDistinctTokens() {
        lock.lock();
        try {
            return (Set) marking.keySet();
        } finally {
            lock.unlock();
        }
    }

    @Override
    public Set<Object> getDistinctTestableTokens() {
        return getDistinctTokens();
    }

    @Override
    public int getNumberOfTokens() {
        lock.lock();
        try {
            int n = 0;
            for (int i : marking.values()) {
                n += i;
            }
            return n;
        } finally {
            lock.unlock();
        }
    }

    @Override
    public int getNumberOfTestedTokens() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        lock.lock();
        try {
            return marking.isEmpty();
        } finally {
            lock.unlock();
        }
    }

    @Override
    public int getTokenCount(Object token) {
        lock.lock();
        try {
            return marking.get(token);
        } finally {
            lock.unlock();
        }
    }

    @Override
    public TimeSet getFreeTimeSet(Object token) {
        lock.lock();
        try {
            return TimeSet.make(0.0, marking.get(token));
        } finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsTestedToken(Object token) {
        return false;
    }
}