package de.renew.formalism.ccpn;

import de.renew.formalism.base.AbstractSingleNetCompiler;

import de.renew.net.CurryPlace;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.TransitionInscription;

import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.SyntaxException;

import java.util.Collection;
import java.util.Collections;


/**
 * This compiler does nothing.
 * Nets in the Curry Net Formalism as supposed to be exported to PNML
 * and compiled by the external CCPN tool.
 *
 * @author Michael Simon
 */
final class SingleCurryNetCompiler extends AbstractSingleNetCompiler {
    private static final String DECL = "declaration";
    private static final String INSC = "inscription";

    @Override
    protected void compile(ShadowPlace shadowPlace, Net net)
                    throws SyntaxException {
        // Determine the name.
        String pname = shadowPlace.getName();
        if (pname == null) {
            placeNum++;
            pname = "P" + placeNum;
        }

        // Create the new place;
        Place place = new CurryPlace(net, pname,
                        new NetElementID(shadowPlace.getID()));
        place.setTrace(shadowPlace.getTrace());

        String pcomment = shadowPlace.getComment();
        if (pcomment != null) {
            place.setComment(pcomment);
        }

        lookup.set(shadowPlace, place);

        compilePlaceInscriptions(shadowPlace, place);
    }

    @Override
    public String checkDeclarationNode(String inscr, boolean special,
                                       ShadowNet shadowNet)
                    throws SyntaxException {
        return DECL;
    }

    @Override
    public String checkArcInscription(String inscr, boolean special,
                                      ShadowNet shadowNet)
                    throws SyntaxException {
        return INSC;
    }

    @Override
    public String checkTransitionInscription(String inscription,
                                             boolean special,
                                             ShadowNet shadowNet)
                    throws SyntaxException {
        return INSC;
    }

    @Override
    public String checkPlaceInscription(String inscr, boolean special,
                                        ShadowNet shadowNet)
                    throws SyntaxException {
        return INSC;
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace,
                                            Place place)
                    throws SyntaxException {
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription inscription)
                    throws SyntaxException {
        return Collections.emptyList();
    }

    @Override
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
    }
}