package de.renew.formalism.ccpn;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.DrawApplication;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.NullDrawing;

import CH.ifa.draw.util.Command;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorPlugin;

import de.renew.engine.simulator.CCPNSimulation;

import de.renew.formalism.FormalismPlugin;

import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;

import de.renew.net.NetNotFoundException;

import de.renew.shadow.SyntaxException;


// TODO offer a dialog similar to ReachabilityGraphCommand
public class CurryReachabilityGraphCommand extends Command {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CurryReachabilityGraphCommand.class);

    public static final String CMD_NAME = "Curry Reachability Graph";

    public CurryReachabilityGraphCommand() {
        super(CMD_NAME);
    }

    @Override
    public void execute() {
        final SimulatorPlugin sp = SimulatorPlugin.getCurrent();
        final FormalismPlugin fp = FormalismPlugin.getCurrent();

        if (!CCPNPlugin.CCPN_COMPILER.equals(fp.getCompiler())) {
            sp.terminateSimulation();
            fp.setCompiler(CCPNPlugin.CCPN_COMPILER);
        }

        // Has to be done after changing the formalism:
        final CCPNSimulation sim = (CCPNSimulation) ModeReplacement
                        .getInstance().getSimulation();
        if (sp.isSimulationActive()) {
            sim.requestReachGraph();
        } else {
            try {
                final String errorStr = CurryReachabilityGraphCommand.class
                                .getSimpleName()
                                + ": Could not start CCPN process for Curry reachability graph generation";
                final DrawApplication gui = DrawPlugin.getGui();
                if (gui != null) {
                    final Drawing drawing = gui.drawing();
                    if (drawing instanceof CPNDrawing) {
                        try {
                            sim.minimalInit(gui.drawing().getName());
                            sim.requestReachGraph();
                        } catch (NoSimulationException | SyntaxException
                                        | NetNotFoundException e) {
                            logger.error(errorStr + ": " + e.getMessage(), e);
                        }
                    } else if (drawing instanceof NullDrawing) {
                        logger.error(errorStr + ": no drawing selected");
                    } else {
                        logger.error(errorStr + " of drawing of the class: "
                                        + drawing.getClass());
                    }
                } else {
                    logger.error(errorStr
                                    + ": no active simulation and no GUI present");
                }
            } finally {
                sp.terminateSimulation();
            }
        }
    }
}
