package de.renew.formalism.ccpn;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.util.CommandMenuItem;

import de.renew.application.SimulatorPlugin;

import de.renew.engine.simulator.CCPNSimulation;
import de.renew.engine.simulator.CurrySimulator;

import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;

import de.renew.gui.ModeReplacement;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;

import java.net.URL;


/**
 * @author Michael Simon
 */
public class CCPNPlugin extends PluginAdapter
                implements FormalismChangeListener {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CCPNPlugin.class);
    public static final String CCPN_COMPILER = "Curry Net Compiler";
    public static final String DEFAULT_SIMULATOR_CLASS = CurrySimulator.class
                    .getName();
    public static final String CCPN_LOCATION_PROPERTY = "de.renew.formalism.ccpn.ccpnbin";
    private static String ccpnLocation;
    private final CommandMenuItem _menuItem = new CommandMenuItem(
                    new CurryReachabilityGraphCommand());
    private String previousSimulatorClass;

    public CCPNPlugin(URL location) throws PluginException {
        super(location);
    }

    public CCPNPlugin(PluginProperties props) {
        super(props);
    }

    @Override
    public void init() {
        ccpnLocation = SimulatorPlugin.getCurrent().getProperties()
                        .getProperty(CCPN_LOCATION_PROPERTY);
        if (ccpnLocation == null) {
            throw new RuntimeException(
                            "The ccpn binary location must be given by: -D"
                                            + CCPN_LOCATION_PROPERTY
                                            + "=path/to/ccpn");
        }

        final DrawPlugin gui = DrawPlugin.getCurrent();
        if (gui != null) {
            gui.getMenuManager().registerMenu(DrawPlugin.TOOLS_MENU, _menuItem,
                            "de.renew.rnrg");
        }

        final FormalismPlugin fp = FormalismPlugin.getCurrent();
        fp.addFormalismChangeListener(this);
        fp.addCompilerFactory(CCPN_COMPILER, new CurryNetCompiler());
        super.init();
    }

    @Override
    public boolean cleanup() {
        final DrawPlugin gui = DrawPlugin.getCurrent();
        if (gui != null) {
            gui.getMenuManager().unregisterMenu(_menuItem);
        }

        final FormalismPlugin fp = FormalismPlugin.getCurrent();
        fp.removeFormalismChangeListener(this);
        fp.removeCompilerFactory(CCPN_COMPILER);

        return true;
    }

    @Override
    public void formalismChanged(String currentCompiler, Object source,
                                 int action) {
        if (action == FormalismChangeListener.CHOOSE) {
            PluginProperties props = SimulatorPlugin.getCurrent()
                            .getProperties();
            String currentSimulator = props
                            .getProperty(SimulatorPlugin.CLASS_PROP_NAME);

            ModeReplacement mr = ModeReplacement.getInstance();

            boolean ccpnCompilerChosen = CCPN_COMPILER.equals(currentCompiler);
            boolean ccpnSimulatorSet = DEFAULT_SIMULATOR_CLASS
                            .equals(currentSimulator);

            if (ccpnCompilerChosen && !ccpnSimulatorSet) {
                // Set the simulator class property to CCPNSimulator
                // and back up its old value.
                previousSimulatorClass = currentSimulator;
                props.setProperty(SimulatorPlugin.CLASS_PROP_NAME,
                                DEFAULT_SIMULATOR_CLASS);

                if (logger.isDebugEnabled()) {
                    logger.debug(CCPNPlugin.class.getSimpleName()
                                    + ": Set simulator class property to "
                                    + DEFAULT_SIMULATOR_CLASS
                                    + ", because formalism " + CCPN_COMPILER
                                    + " was chosen.");
                }

                mr.getSimulation().dispose();
                mr.setSimulation(new CCPNSimulation(mr.getDrawingLoader()));
            } else if (!ccpnCompilerChosen && ccpnSimulatorSet) {
                mr.getSimulation().dispose();
                mr.setSimulation(null);
                // Reset the simulator class property.
                if (previousSimulatorClass == null) {
                    props.remove(SimulatorPlugin.CLASS_PROP_NAME);

                    if (logger.isDebugEnabled()) {
                        logger.debug(CCPNPlugin.class.getSimpleName()
                                        + ": Remove simulator class property set to "
                                        + DEFAULT_SIMULATOR_CLASS + ", because "
                                        + CCPN_COMPILER
                                        + " is no longer the chosen formalism.");
                    }
                } else {
                    props.setProperty(SimulatorPlugin.CLASS_PROP_NAME,
                                    previousSimulatorClass);

                    if (logger.isDebugEnabled()) {
                        logger.debug(CCPNPlugin.class.getSimpleName()
                                        + ": Set simulator class property to old value "
                                        + previousSimulatorClass
                                        + " and remove the distribute extension, because "
                                        + CCPN_COMPILER
                                        + " is no longer the chosen formalism.");
                    }
                }
            }
        }
    }

    public static String getCCPNLocation() {
        return ccpnLocation;
    }
}
