package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;


public class CurrySimulator implements Simulator {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CurrySimulator.class);
    private CCPNProcess process;

    public CurrySimulator(boolean wantEventQueueDelay) {
        this();
    }

    public CurrySimulator() {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    private synchronized boolean processStopped() {
        if (logger.isDebugEnabled()) {
            logger.debug(CurrySimulator.class.getSimpleName()
                            + ": determining if CCPN process is stopped: "
                            + process);
        }
        return process == null || process.stopped;
    }

    @Override
    public synchronized void startRun() {
        if (!processStopped()) {
            process.continuousUpdate = true;
            process.run();
        }
    }

    public void setProcess(CCPNProcess process) {
        this.process = process;
    }

    @Override
    public synchronized void stopRun() {
        if (!processStopped()) {
            process.continuousUpdate = false;
            process.stop();
        }
    }

    @Override
    public synchronized void terminateRun() {
        if (process != null) {
            process.terminate();
            process = null;
        }
    }

    @Override
    public synchronized int step() {
        if (processStopped()) {
            return Simulator.statusStopped;
        }

        if (process.continuousUpdate) {
            stopRun();
        } else {
            process.step();
        }

        // TODO correct return code
        return -1;
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean isSequential() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public long[] collectSimulationRunIds() {
        // TODO Auto-generated method stub
        return null;
    }
}