package de.renew.engine.simulator;

import de.renew.application.NoSimulationException;

import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.CCPNDrawingHelper;

import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;

import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;

import de.renew.shadow.SyntaxException;

import java.rmi.RemoteException;


public class CCPNSimulation extends CPNSimulation {
    private boolean startRunning = false;
    private CCPNProcess process;

    public CCPNSimulation(CPNDrawingLoader loader) {
        super(false, loader);
    }

    @Override
    public void simulationRun() {
        startRunning = true;
        super.simulationRun();
    }

    @Override
    public void simulationTerminate() {
        startRunning = false;
        super.simulationTerminate();
    }

    public NetInstanceAccessor minimalInit(String mainNet)
                    throws SyntaxException, NetNotFoundException,
                    NoSimulationException {
        NetInstanceAccessorImpl instance = (NetInstanceAccessorImpl) super.initSimulation(
                        mainNet);

        /** Start process **/
        CPNInstanceDrawing drawing;
        try {
            drawing = CPNInstanceDrawing.getInstanceDrawing(instance);
        } catch (RemoteException e) {
            throw new RuntimeException(e);
        }

        process = CCPNProcess.startProcess((NetInstance) instance.getObject(),
                        CCPNDrawingHelper.extract(drawing));

        // The process always has to be passed to the simulator
        // for it to be able to terminate it.
        ((CurrySimulator) getSimulatorPlugin().getCurrentEnvironment()
                        .getSimulator()).setProcess(process);

        return instance;
    }

    @Override
    public NetInstanceAccessor initSimulation(String mainNet)
                    throws SyntaxException, NetNotFoundException,
                    NoSimulationException {
        NetInstanceAccessor instance = minimalInit(mainNet);

        /** Start run or step **/
        if (startRunning) {
            process.continuousUpdate = true;
            process.run();
        } else {
            process.step();
        }

        return instance;
    }

    public void requestReachGraph() {
        process.reachGraph();
    }
}
