#!/bin/sh
if [ "$#" -ne 1 ]; then
    echo "usage: $0 parent_directory" >&2
    exit 1
fi

echo "You need to have Git installed."
# Install Stack (failure is OK):
# For details on Stack and its manual installation see https://haskell-lang.org/get-started
wget -qO- https://get.haskellstack.org/ | sh
# Create given directory:
mkdir -p "$1" &&
# Go there:
cd "$1" &&
# Clone the master branch from the CCPN repository:
git clone -b renew-2.6 --single-branch https://git.informatik.uni-hamburg.de/tgipublic/ccpn/ccpn.git &&
# Go there:
cd ccpn &&
# Build CCPN:
make setup &&
# Print helpful instruction for running Renew with CCPN:
echo "Pass the CCPN location to Renew by starting it with:" &&
echo "java -Dde.renew.formalism.ccpn.ccpnbin=$1/ccpn/bin/ccpn -jar dist/loader.jar gui"
