package de.renew.appleui;

import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;

import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.AppReopenedEvent;
import java.awt.desktop.AppReopenedListener;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.SystemEventListener;

import java.io.File;

import java.util.List;


/**
 * This listener actually does the work which is promised by the
 * {@link AppleUI} plugin. It handles Apple-specific application
 * events.
 * <p>
 * </p>
 * Created: Thu Jul  8  2004
 *
 * @author Michael Duvigneau
 **/
class AppleUIListener implements AboutHandler, SystemEventListener, QuitHandler,
                OpenFilesHandler, AppReopenedListener {
    private AboutDisplayer displayer = null;

    /**
     * Configures an <code>AboutDisplayer</code>.
     *
     * @param displayer  the about box displayer.
     **/
    void setAboutDisplayer(AboutDisplayer displayer) {
        this.displayer = displayer;
    }

    /**
     * Tells the plugin system to shut down when Command-Q has been pressed (or
     * a similar event occurs).
     **/
    @Override
    public void handleQuitRequestWith(QuitEvent arg0, QuitResponse arg1) {
        PluginManager.getInstance().stop();
        // Tell MacOS that handling the request may take some
        // time...
    }

    //    @Override
    //    public void printFiles(PrintFilesEvent arg0) {
    //        // TODO Auto-generated method stub
    //    }
    @Override
    public void openFiles(OpenFilesEvent openFilesEvent) {

        /**
         * Tries to open the file by issuing a <code>"gui"</code> command to the
         * plugin system. However, this command will only be available if the
         * "Renew Gui" plugin is loaded.
         **/
        CLCommand guiCommand = PluginManager.getInstance().getCLCommands()
                        .get("gui");
        if (guiCommand != null) {
            List<File> files = openFilesEvent.getFiles();
            String[] filenames = new String[files.size()];
            int i = 0;
            for (File file : files) {
                filenames[i++] = file.getPath();
            }
            guiCommand.execute(filenames, System.out);
        }
    }

    /**
     * Tries to bring the main menu frame to front.
     * However, this command will
     * only be available if the "Renew Gui" plugin is loaded.
     **/
    @Override
    public void appReopened(AppReopenedEvent arg0) {
        displayer.bringMenuFrameToFront();
    }

    //    @Override
    //    public void handlePreferences(PreferencesEvent arg0) {
    //        // TODO Auto-generated method stub
    //    }

    /**
     * Opens the editor's about box if the "Renew Gui" plugin is loaded.
     **/
    @Override
    public void handleAbout(AboutEvent arg0) {
        displayer.displayAboutBox();
    }
}