/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.jfiglet.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.gnu.jfiglet.core.FIGCharacter;
import org.gnu.jfiglet.core.FIGFontInfo;
import org.gnu.jfiglet.core.FIGFontLayout;
import org.gnu.jfiglet.core.IllegalFIGFontFileException;

public class FIGFont {
    public static final int MAX_8BIT_CHARSET_CHAR_CODE = 255;
    private static final String FIG_FONT_HEADER_TOKEN_SEPARATOR = " ";
    private static final String FIGFONT_FILE_SIGNATURE = "flf2a";
    private static final String FIGFONT_EXTENSION = "flf";
    private static final String FONT_DIRECTORY_NAME = "fonts";
    private FIGFontInfo info = null;
    private FIGCharacter[] eightBitCharacterSet = new FIGCharacter[256];

    public FIGFont(String theName) {
        this.info = new FIGFontInfo();
        this.info.setName(theName);
    }

    public void loadFromFile() throws IOException, ZipException, IllegalFIGFontFileException {
        String fontFilePath = "fonts/" + this.info.getName() + "." + FIGFONT_EXTENSION;
        URL fontFileURL = ClassLoader.getSystemResource(fontFilePath);
        if (fontFileURL == null) {
            throw new IllegalFIGFontFileException("Cannot find " + fontFilePath + " in the classpath.");
        }
        InputStream fontFileInputStream = fontFileURL.openStream();
        ZipInputStream fontFileZipInputStream = new ZipInputStream(fontFileInputStream);
        ZipEntry entry = fontFileZipInputStream.getNextEntry();
        if (entry == null) {
            fontFileZipInputStream.close();
            fontFileInputStream.close();
            fontFileInputStream = fontFileURL.openStream();
        } else {
            fontFileInputStream = fontFileZipInputStream;
        }
        this.readFontFile(fontFileInputStream);
        fontFileInputStream.close();
    }

    public FIGCharacter getFIGCharacter(int theCharacterCode) {
        if (theCharacterCode < 0 || theCharacterCode > 255) {
            throw new IllegalArgumentException("The character code is an integer between 0 and 255 included");
        }
        FIGCharacter returnValue = this.eightBitCharacterSet[theCharacterCode];
        if (returnValue == null) {
            returnValue = this.eightBitCharacterSet[0];
        }
        return this.eightBitCharacterSet[theCharacterCode];
    }

    public FIGFontInfo getInfo() {
        return this.info;
    }

    private void readFontFile(InputStream theFontFile) throws IOException, IllegalFIGFontFileException {
        BufferedReader fontFileReader = new BufferedReader(new InputStreamReader(theFontFile));
        String fontFileHeaderLine = fontFileReader.readLine();
        try {
            FIGFontInfo infosFromTheHeader = this.populateFIGFontInfoFromFIGFontFileHeader(fontFileHeaderLine);
            infosFromTheHeader.setName(this.info.getName());
            this.info = infosFromTheHeader;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalFIGFontFileException(e.getMessage());
        }
        for (int i = 0; i < this.info.getCommentLinesNumber(); ++i) {
            this.info.addCommentLine(fontFileReader.readLine());
        }
        for (int currentCharCode = 32; currentCharCode < 127; ++currentCharCode) {
            String[] characterLines = new String[this.info.getHeight()];
            for (int i = 0; i < this.info.getHeight(); ++i) {
                characterLines[i] = fontFileReader.readLine();
            }
            this.eightBitCharacterSet[currentCharCode] = new FIGCharacter(characterLines);
        }
        int[] deutchCharactersCodes = new int[]{196, 214, 220, 228, 246, 252, 223};
        for (int i = 0; i < deutchCharactersCodes.length; ++i) {
            String[] characterLines = new String[this.info.getHeight()];
            for (int j = 0; j < this.info.getHeight(); ++j) {
                characterLines[j] = fontFileReader.readLine();
            }
            this.eightBitCharacterSet[deutchCharactersCodes[i]] = new FIGCharacter(characterLines);
        }
        boolean readNextCharacterDefinition = true;
        while (readNextCharacterDefinition) {
            String characterHeader = fontFileReader.readLine();
            if (characterHeader == null) {
                readNextCharacterDefinition = false;
                break;
            }
            StringTokenizer tokenizer = new StringTokenizer(characterHeader);
            String characterCodeAsString = tokenizer.nextToken(FIG_FONT_HEADER_TOKEN_SEPARATOR);
            try {
                int characterCode = this.decodeCharacterCode(characterCodeAsString);
                String[] characterLines = new String[this.info.getHeight()];
                for (int i = 0; i < this.info.getHeight(); ++i) {
                    characterLines[i] = fontFileReader.readLine();
                    if (characterLines[i] != null) continue;
                    throw new IllegalFIGFontFileException("Character which code is " + characterCode + " is not entirely defined");
                }
                if (characterCode <= 0 || characterCode >= 255) continue;
                this.eightBitCharacterSet[characterCode] = new FIGCharacter(characterLines);
            }
            catch (NumberFormatException e) {
                throw new IllegalFIGFontFileException("Line \"" + characterHeader + " is uncorrect");
            }
        }
    }

    private FIGFontInfo populateFIGFontInfoFromFIGFontFileHeader(String theFIGFontFileHeader) {
        FIGFontInfo informations = new FIGFontInfo();
        if (theFIGFontFileHeader == null) {
            throw new IllegalArgumentException("The header is null");
        }
        int oldLayout = -10;
        Integer fullLayout = null;
        StringTokenizer tokenizer = new StringTokenizer(theFIGFontFileHeader, FIG_FONT_HEADER_TOKEN_SEPARATOR);
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens < 6) {
            throw new IllegalArgumentException("Not enough tokens in the header");
        }
        if (numberOfTokens > 9) {
            throw new IllegalArgumentException("Too many tokens in the header");
        }
        String signatureAndHardblank = tokenizer.nextToken();
        if (!FIGFONT_FILE_SIGNATURE.equals(signatureAndHardblank.substring(0, FIGFONT_FILE_SIGNATURE.length()))) {
            throw new IllegalArgumentException("Uncorrect signature");
        }
        informations.setHardblank(signatureAndHardblank.charAt(FIGFONT_FILE_SIGNATURE.length()));
        try {
            informations.setHeight(Integer.parseInt(tokenizer.nextToken()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Font height must be an integer");
        }
        try {
            informations.setBaseline(Integer.parseInt(tokenizer.nextToken()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Font baseline must be an integer");
        }
        try {
            informations.setMaxLength(Integer.parseInt(tokenizer.nextToken()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Font max length must be an integer");
        }
        try {
            oldLayout = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Old layout must be an integer");
        }
        try {
            informations.setCommentLinesNumber(Integer.parseInt(tokenizer.nextToken()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The number of lines of comments must be an integer");
        }
        try {
            try {
                Integer printDirection = new Integer(tokenizer.nextToken());
                if (printDirection != null) {
                    if (printDirection != 0 && printDirection != 1) {
                        throw new IllegalArgumentException("Accepted values for printDirection are 0 for LEFT_TO_RIGHT and 1 for RIGHT_TO_LEFT");
                    }
                    informations.setPrintDirection(printDirection);
                }
                try {
                    fullLayout = new Integer(tokenizer.nextToken());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The Full Layout must be an integer");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The print direction must be an integer");
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        informations.setLayout(new FIGFontLayout(oldLayout, fullLayout));
        return informations;
    }

    private int decodeCharacterCode(String theCharacterCodeAsString) {
        String codeAsString = new String(theCharacterCodeAsString);
        int sign = 1;
        int characterCodeRadix = 10;
        if (codeAsString.charAt(0) == '-') {
            sign = -1;
            codeAsString = codeAsString.substring(1);
        }
        if (codeAsString.charAt(0) == '0') {
            characterCodeRadix = 8;
            if ((codeAsString = codeAsString.substring(1)).charAt(0) == 'X' || codeAsString.charAt(0) == 'x') {
                characterCodeRadix = 16;
                codeAsString = codeAsString.substring(1);
            }
        }
        return sign * Integer.parseInt(codeAsString, characterCodeRadix);
    }
}

