/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaHighlighter;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaCaret
extends DefaultCaret
implements UIResource,
PropertyChangeListener {
    final boolean isMultiLineEditor;
    final JTextComponent c;
    boolean mFocused = false;
    private boolean shouldSelectAllOnFocus = true;
    boolean fPainting = false;

    public AquaCaret(Window window, JTextComponent jTextComponent) {
        this.c = jTextComponent;
        this.isMultiLineEditor = this.c instanceof JTextArea || this.c instanceof JEditorPane;
        jTextComponent.addPropertyChangeListener(this);
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return AquaHighlighter.getInstance();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            bl = this.getDot() == this.getMark();
        }
        super.setVisible(bl);
    }

    @Override
    public void setSelectionVisible(boolean bl) {
        if (this.isMultiLineEditor) {
            super.setSelectionVisible(true);
            this.c.repaint();
            return;
        }
        super.setSelectionVisible(bl);
    }

    @Override
    protected void fireStateChanged() {
        if (this.mFocused) {
            this.setVisible(this.getComponent().isEditable());
        }
        super.fireStateChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("Frame.active".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.setVisible(jTextComponent.hasFocus());
            } else {
                this.setVisible(false);
            }
            if (this.getDot() != this.getMark()) {
                jTextComponent.getUI().damageRange(jTextComponent, this.getDot(), this.getMark());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        int n;
        JTextComponent jTextComponent = this.getComponent();
        if (!jTextComponent.isEnabled() || !jTextComponent.isEditable()) {
            super.focusGained(focusEvent);
            return;
        }
        this.mFocused = true;
        if (!this.shouldSelectAllOnFocus) {
            this.shouldSelectAllOnFocus = true;
            super.focusGained(focusEvent);
            return;
        }
        if (this.isMultiLineEditor) {
            super.focusGained(focusEvent);
            return;
        }
        int n2 = jTextComponent.getDocument().getLength();
        int n3 = this.getDot();
        if (n3 == (n = this.getMark())) {
            if (n3 == 0) {
                jTextComponent.setCaretPosition(n2);
                jTextComponent.moveCaretPosition(0);
            } else if (n3 == n2) {
                jTextComponent.setCaretPosition(0);
                jTextComponent.moveCaretPosition(n2);
            }
        }
        super.focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mFocused = false;
        this.shouldSelectAllOnFocus = true;
        super.focusLost(focusEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            super.mousePressed(mouseEvent);
            this.shouldSelectAllOnFocus = false;
        }
    }

    @Override
    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle == null || this.fPainting) {
            return;
        }
        this.x = rectangle.x - 4;
        this.y = rectangle.y;
        this.width = 10;
        this.height = rectangle.height;
        Rectangle rectangle2 = new Rectangle(this.x, this.y, this.width, this.height);
        Border border = this.getComponent().getBorder();
        if (border != null) {
            Rectangle rectangle3 = this.getComponent().getBounds();
            rectangle3.y = 0;
            rectangle3.x = 0;
            Insets insets = border.getBorderInsets(this.getComponent());
            rectangle3.x += insets.left;
            rectangle3.y += insets.top;
            rectangle3.width -= insets.left + insets.right;
            rectangle3.height -= insets.top + insets.bottom;
            Rectangle2D.intersect(rectangle2, rectangle3, rectangle2);
        }
        this.x = rectangle2.x;
        this.y = rectangle2.y;
        this.width = Math.max(rectangle2.width, 1);
        this.height = Math.max(rectangle2.height, 1);
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            this.fPainting = true;
            super.paint(graphics);
            this.fPainting = false;
        }
    }
}

