/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.DecodingInputStream;
import org.freehep.util.io.RunLength;

public class RunLengthInputStream
extends DecodingInputStream
implements RunLength {
    private int[] buffer = new int[128];
    private int index;
    private int count;
    private InputStream in;

    public RunLengthInputStream(InputStream input) {
        this.in = input;
        this.index = 0;
        this.count = 0;
    }

    public int read() throws IOException {
        if (!(this.index < this.count && this.index <= 128 || this.fillBuffer())) {
            return -1;
        }
        int b = this.buffer[this.index];
        ++this.index;
        return b & 0xFF;
    }

    private boolean fillBuffer() throws IOException {
        this.count = this.in.read();
        if (this.end(this.count)) {
            return false;
        }
        if (this.count < 128) {
            ++this.count;
            for (int i = 0; i < this.count; ++i) {
                this.buffer[i] = this.in.read();
                if (!this.end(this.buffer[i])) continue;
                return false;
            }
        } else {
            this.count = 257 - this.count;
            int b = this.in.read();
            if (this.end(b)) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                this.buffer[i] = b;
            }
        }
        this.index = 0;
        return true;
    }

    private boolean end(int b) {
        return b < 0 || b == 128;
    }
}

