/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.LogStrategy;
import de.renew.plugin.PluginManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class DefaultLogStrategy
implements LogStrategy {
    public static final String LOG_CONFIG_PROPERTY_NAME = "log4j.configuration";
    public static final String LOG_HOME_PROPERTY_NAME = "logs.home";
    public static final String LOG_HOME_DEFAULT_LOCATION = "renewlogs";
    public static final String LOG4J_PROPERTIES_FILE = "log4j.properties";
    public static final String LOG4J_XML_FILE = "log4j.xml";

    @Override
    public void configureLogging() {
        Object object;
        Vector<String> vector = new Vector<String>();
        String string = null;
        if ((string = this.tryConfigurationByPropertyName(vector, string)) == null) {
            try {
                object = PluginManager.getLoaderLocation();
                String string2 = ((URL)object).toExternalForm();
                string2 = string2.substring(0, string2.lastIndexOf("/"));
                string = this.tryXMLConfigurationHome(vector, string, string2);
                if (string == null) {
                    string = this.tryPropertiesConfigurationHome(vector, string, string2);
                }
            }
            catch (Exception exception) {
                vector.add(exception.toString());
            }
            if (string == null) {
                string = this.fallbackConfiguration(vector);
            }
        }
        if (!vector.isEmpty()) {
            object = vector.iterator();
            while (object.hasNext()) {
                PluginManager.logger.error(object.next());
            }
        }
        if (PluginManager.logger.isDebugEnabled()) {
            PluginManager.logger.debug((Object)("Used " + string + " to configure Log4j."));
        }
    }

    private String fallbackConfiguration(Vector<String> vector) {
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new SimpleLayout());
        consoleAppender.setThreshold((Priority)Level.INFO);
        BasicConfigurator.configure((Appender)consoleAppender);
        vector.add("No log4j configuration file found, falling back to failsaife settings.");
        String string = "failsafe settings";
        return string;
    }

    private String tryPropertiesConfigurationHome(Vector<String> vector, String string, String string2) throws MalformedURLException, URISyntaxException, IOException, FileNotFoundException {
        URL uRL = new URL(string2 + "/config/log4j.properties");
        File file = new File(new URI(uRL.toExternalForm()));
        File file2 = new File(String.valueOf(PluginManager.getPreferencesLocation()) + File.separator + ".log4j.properties");
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = new Properties();
        boolean bl = false;
        if (file.exists() && file.isFile()) {
            properties.load(new FileInputStream(file));
            stringBuffer.append(file.getAbsolutePath());
            bl = true;
        }
        if (file2.exists() && file2.isFile()) {
            properties.load(new FileInputStream(file2));
            if (bl) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(file2.getAbsolutePath());
            bl = true;
        } else {
            File file3 = new File(System.getProperty("user.home") + File.separator + ".log4j.properties");
            if (file3.exists() && file3.isFile()) {
                vector.add("The default location for the configuration file of log4j logging was moved from the users' home folder to the \"" + String.valueOf(PluginManager.getPreferencesLocation()) + "\" sub-directory.");
            }
        }
        if (bl) {
            try {
                PropertyConfigurator.configure((Properties)properties);
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                vector.add("An error occured during the configuration of the logging framework using the properties configuration file(s) " + stringBuffer.toString() + ". Error was: " + exception.toString());
            }
        }
        return string;
    }

    private String tryXMLConfigurationHome(Vector<String> vector, String string, String string2) throws MalformedURLException, URISyntaxException, FactoryConfigurationError {
        File file;
        if (System.getProperty(LOG_HOME_PROPERTY_NAME) == null) {
            file = new File(String.valueOf(PluginManager.getPreferencesLocation()) + File.separator + LOG_HOME_DEFAULT_LOCATION);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!file.isDirectory()) {
                file = file.getParentFile();
            } else {
                System.setProperty(LOG_HOME_PROPERTY_NAME, file.getAbsolutePath());
            }
        }
        URL uRL = new URL(string2 + "/config/log4j.xml");
        file = new File(new URI(uRL.toExternalForm()));
        File file2 = new File(String.valueOf(PluginManager.getPreferencesLocation()) + File.separator + ".log4j.xml");
        if (file2.exists() && file2.isFile()) {
            file = file2;
        }
        if (file.exists() && file.isFile()) {
            try {
                DOMConfigurator.configure((String)file.getAbsolutePath());
                string = file.getAbsolutePath();
            }
            catch (Exception exception) {
                vector.add("An error occured during the configuration of the logging framework using the xml configuration file in the default config directory of the renew distribution.Error was: " + exception.toString());
            }
        }
        return string;
    }

    private String tryConfigurationByPropertyName(Vector<String> vector, String string) throws FactoryConfigurationError {
        try {
            String string2 = System.getProperty(LOG_CONFIG_PROPERTY_NAME);
            if (string2 != null) {
                if (string2.endsWith(".xml")) {
                    DOMConfigurator.configure((String)string2);
                } else {
                    PropertyConfigurator.configure((String)string2);
                }
                string = string2;
            }
        }
        catch (Exception exception) {
            vector.add("A error occured while configuring the logging framework using the configuration file given by the property log4j.configuration. The following exception was thrown: " + exception.toString());
        }
        return string;
    }
}

