/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatMultiAbstract;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ExportClCommand
implements CLCommand,
StatusDisplayer {
    private static final String SYNOPSIS = "Exports a drawing. Usage: ex <type> [drawing]+ [options]";
    private static Logger logger = Logger.getLogger(ExportClCommand.class);

    /*
     * WARNING - void declaration
     */
    public void execute(String[] stringArray, PrintStream printStream) {
        DefaultParser defaultParser = new DefaultParser();
        Options options = new Options();
        options.addOption("a", "accumulate", false, "n-to-1 export (only available for some formats, e.g. ShadowNetSystem)");
        options.addOption("o", "output", true, "output file");
        ExportHolderImpl exportHolderImpl = (ExportHolderImpl)DrawPlugin.getCurrent().getExportHolder();
        List<ExportFormat> list = this.flattenedExportFormats();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            printStream.append("Could not parse command.\n");
            this.printHelp(printStream, list, options);
            return;
        }
        List list2 = commandLine.getArgList();
        if (list2.size() < 2) {
            printStream.append("Not enough arguments.\n");
            this.printHelp(printStream, list, options);
            return;
        }
        String string = (String)list2.remove(0);
        List list3 = list2;
        boolean bl = commandLine.hasOption("a");
        if (list3.size() > 1 && commandLine.hasOption("o") && !bl) {
            printStream.append("Cannot export multiple drawings with custom output file (except for n-to-1 export).\n");
            this.printHelp(printStream, list, options);
            return;
        }
        ExportFormat exportFormat = null;
        String string2 = string;
        for (ExportFormat object : list) {
            logger.debug((Object)object);
            if (!object.formatName().equalsIgnoreCase(string)) continue;
            exportFormat = object;
            logger.info((Object)(ExportClCommand.class.getSimpleName() + ": format is " + object.formatName()));
            Object object2 = object.fileFilter();
            if (!(object2 instanceof SimpleFileFilter)) break;
            string2 = ((SimpleFileFilter)object2).getExtension();
            break;
        }
        if (exportFormat == null) {
            printStream.append("Export format not found.\n");
            return;
        }
        if (bl) {
            void var15_20;
            if (!exportFormat.canExportNto1()) {
                printStream.append("Export format does not support n-to-1 export.\n");
                return;
            }
            Iterator<Drawing> iterator = new ArrayList();
            for (Object object2 : list3) {
                logger.info((Object)(ExportClCommand.class.getSimpleName() + ": add filename to n-to-1 export " + (String)object2));
                File file = new File((String)object2);
                if (!file.exists()) continue;
                iterator.add(DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this));
            }
            if (commandLine.hasOption("o")) {
                File file = new File(commandLine.getOptionValue("o"));
            } else {
                File file = new File(((Drawing)iterator.get(0)).getName() + ".sns");
            }
            exportHolderImpl.saveDrawings(Collections.enumeration(iterator), exportFormat, (File)var15_20, (StatusDisplayer)this);
            logger.info((Object)(ExportClCommand.class.getSimpleName() + ": exported n-to-1  " + var15_20.getAbsolutePath()));
        } else if (commandLine.hasOption("o")) {
            this.exportSingleDrawing(exportHolderImpl, exportFormat, string2, (String)list3.get(0), commandLine.getOptionValue("o"));
        } else {
            for (String string3 : list3) {
                this.exportSingleDrawing(exportHolderImpl, exportFormat, string2, string3, null);
            }
        }
    }

    public List<ExportFormat> flattenedExportFormats() {
        ExportHolder exportHolder = DrawPlugin.getCurrent().getExportHolder();
        ExportFormat[] exportFormatArray = exportHolder.allExportFormats();
        LinkedList<ExportFormat> linkedList = new LinkedList<ExportFormat>(Arrays.asList(exportFormatArray));
        ArrayList<ExportFormat> arrayList = new ArrayList<ExportFormat>();
        while (!linkedList.isEmpty()) {
            ExportFormat exportFormat = (ExportFormat)linkedList.poll();
            if (exportFormat instanceof ExportFormatMultiAbstract) {
                ExportFormatMultiAbstract exportFormatMultiAbstract = (ExportFormatMultiAbstract)exportFormat;
                List list = exportFormatMultiAbstract.formats();
                for (ExportFormat exportFormat2 : list) {
                    linkedList.add(exportFormat2);
                }
                continue;
            }
            arrayList.add(exportFormat);
        }
        Collections.sort(arrayList, new Comparator<ExportFormat>(){

            @Override
            public int compare(ExportFormat exportFormat, ExportFormat exportFormat2) {
                return exportFormat.formatName().compareTo(exportFormat2.formatName());
            }
        });
        return arrayList;
    }

    private void exportSingleDrawing(ExportHolderImpl exportHolderImpl, ExportFormat exportFormat, String string, String string2, String string3) {
        logger.info((Object)(ExportClCommand.class.getName() + ": filename is " + string2));
        File file = new File(string2);
        if (file.exists()) {
            Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this);
            logger.info((Object)(ExportClCommand.class.getName() + ": drawing is " + drawing.getName()));
            File file2 = string3 == null ? new File(drawing.getFilename().getAbsoluteFile().getParentFile(), drawing.getName() + "." + string) : new File(string3);
            logger.info((Object)(ExportClCommand.class.getName() + ": path is " + String.valueOf(file2)));
            exportHolderImpl.saveDrawing(drawing, exportFormat, file2, (StatusDisplayer)this);
        }
    }

    public String getDescription() {
        return "Exports a drawing. Usage: ex <type> [drawing]+ [options] Type ex for a list of supported formats and options.";
    }

    public void showStatus(String string) {
        logger.info((Object)(ExportClCommand.class.getName() + " Status: " + string));
    }

    public String getArguments() {
        List<ExportFormat> list = this.flattenedExportFormats();
        Object object = "";
        if (list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            for (int i = 0; i < list.size(); ++i) {
                ExportFormat exportFormat = list.get(i);
                stringBuilder.append(exportFormat.formatName());
                if (i >= list.size() - 1) continue;
                stringBuilder.append("|");
            }
            stringBuilder.append(")");
            stringBuilder.append(" ");
            object = stringBuilder.toString();
        }
        object = (String)object + "[fileNames|-o|-a]*";
        return object;
    }

    private void printHelp(PrintStream printStream, List<ExportFormat> list, Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        String string = "Exports a drawing.";
        helpFormatter.printHelp(new PrintWriter(printStream, true), 74, "ex <type> [drawing]+", string, options, 1, 3, null, true);
        printStream.append("List of available formats:\n");
        for (ExportFormat exportFormat : list) {
            printStream.append(ExportClCommand.class.getSimpleName() + ": " + String.valueOf(exportFormat) + "\n");
            if (!exportFormat.canExportNto1()) continue;
            printStream.append(ExportClCommand.class.getSimpleName() + ": " + String.valueOf(exportFormat) + " -a file.rnw [morefiles.rnw] (n-to-1)\n");
        }
    }
}

