/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.engine.events.SimulationEvent;
import de.renew.gui.logging.RepositoryChangeBuffer;
import de.renew.gui.logging.StepTrace;
import de.renew.gui.logging.StepTraceChangeListener;
import de.renew.gui.logging.TableModel;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class StepTableModel
extends TableModel
implements StepTraceChangeListener {
    private static Logger logger = Logger.getLogger(StepTableModel.class);
    private StepTrace stepTrace;
    private RepositoryChangeBuffer eventBuffer;

    public StepTableModel(StepTrace stepTrace, RepositoryChangeBuffer repositoryChangeBuffer) {
        super(false);
        this.stepTrace = stepTrace;
        this.eventBuffer = repositoryChangeBuffer;
        repositoryChangeBuffer.addStepTraceChangeListener(this);
        stepTrace.addStepTraceChangeListener(repositoryChangeBuffer);
        Object[] objectArray = stepTrace.getEvents();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(StepTableModel.class.getSimpleName() + ": Initially including " + objectArray.length + " events for " + String.valueOf(stepTrace) + ".\n" + Arrays.toString(objectArray)));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.addRow(new Object[]{objectArray[i]});
        }
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        if (stepTrace == this.stepTrace) {
            SimulationEvent[] simulationEventArray = stepTrace.getEvents();
            for (int i = this.getRowCount(); i < simulationEventArray.length; ++i) {
                this.addRow(new Object[]{simulationEventArray[i]});
            }
            this.fireTableRowsInserted(this.getRowCount() - simulationEventArray.length - 1, this.getRowCount() - 1);
        }
    }

    public void dispose() {
        this.stepTrace.removeStepTraceChangeListener(this.eventBuffer);
        this.eventBuffer.removeStepTraceChangeListener(this);
    }
}

