/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;
import de.renew.gui.logging.AbstractRepository;
import de.renew.gui.logging.MainRepository;
import de.renew.gui.logging.RepositoryChangeListener;
import de.renew.gui.logging.StepTrace;
import de.renew.gui.logging.StepTraceRemoveRequest;
import de.renew.gui.logging.StepTraceRepository;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class LoggerRepository
extends AbstractRepository
implements RepositoryChangeListener {
    private int capacity = 0;
    private List<StepIdentifier> stepTraces = new LinkedList<StepIdentifier>();
    private MainRepository repository;

    LoggerRepository(MainRepository mainRepository, int n) {
        if (n >= 0) {
            this.capacity = n;
        }
        this.repository = mainRepository;
    }

    public void setCapacity(int n) {
        if (n >= 0) {
            this.capacity = n;
        }
    }

    @Override
    public StepTrace[] getStepTraces(StepIdentifier[] stepIdentifierArray) {
        Vector<StepIdentifier> vector = new Vector<StepIdentifier>();
        for (int i = 0; i < stepIdentifierArray.length; ++i) {
            if (!this.stepTraces.contains(stepIdentifierArray[i])) continue;
            vector.add(stepIdentifierArray[i]);
        }
        return this.repository.getStepTraces(vector.toArray(new StepIdentifier[0]));
    }

    @Override
    public StepTrace[] getAllStepTraces() {
        return this.repository.getStepTraces(this.stepTraces.toArray(new StepIdentifier[0]));
    }

    @Override
    public StepTrace getStepTrace(StepIdentifier stepIdentifier) {
        if (!this.stepTraces.contains(stepIdentifier)) {
            return null;
        }
        return this.repository.getStepTrace(stepIdentifier);
    }

    @Override
    public boolean removeStepTrace(StepIdentifier stepIdentifier) {
        boolean bl = this.stepTraces.remove(stepIdentifier);
        if (bl) {
            StepTrace stepTrace = this.repository.getStepTrace(stepIdentifier);
            this.repository.removeStepTrace(stepIdentifier);
            this.fireStepTraceRemoved(stepTrace);
        }
        return bl;
    }

    @Override
    public void addEvent(SimulatorEvent simulatorEvent) {
        this.repository.addEvent(simulatorEvent);
        if (!this.stepTraces.contains(simulatorEvent.getStep())) {
            if (this.capacity > 0 && this.stepTraces.size() > this.capacity - 1) {
                while (this.stepTraces.size() > this.capacity - 1) {
                    StepIdentifier stepIdentifier = this.stepTraces.get(0);
                    this.removeStepTrace(stepIdentifier);
                }
            }
            this.stepTraces.add(simulatorEvent.getStep());
            this.fireStepTraceAdded(this.repository.getStepTrace(simulatorEvent.getStep()));
        }
    }

    @Override
    public void stepTraceAdded(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        if (this.stepTraces.contains(stepTrace.getStepIdentifier())) {
            this.fireStepTraceAdded(stepTrace);
        }
    }

    @Override
    public void stepTraceRemoved(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
    }

    @Override
    public void stepTraceRemoveRequest(StepTraceRemoveRequest stepTraceRemoveRequest) {
        if (this.stepTraces.contains(stepTraceRemoveRequest.getStepTrace().getStepIdentifier())) {
            stepTraceRemoveRequest.veto();
        } else {
            this.fireStepTraceRemoveRequest(stepTraceRemoveRequest.getStepTrace());
        }
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        if (this.stepTraces.contains(stepTrace.getStepIdentifier())) {
            this.fireStepTraceChanged(stepTrace);
        }
    }
}

