/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.GridConstrainer;
import CH.ifa.draw.util.GUIProperties;
import de.renew.plugin.PluginProperties;
import java.awt.Point;

public class SnapToGridCommand
extends UndoableCommand {
    private Point fGrid;

    public SnapToGridCommand(String string) {
        super(string);
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    @Override
    public boolean executeUndoable() {
        Cloneable cloneable;
        Object object;
        DrawingView drawingView = this.getEditor().view();
        PointConstrainer pointConstrainer = drawingView.getConstrainer();
        if (pointConstrainer == null) {
            int n;
            object = DrawPlugin.getCurrent();
            if (object == null) {
                cloneable = GUIProperties.getProperties();
                n = ((PluginProperties)cloneable).getIntProperty("ch.ifa.draw.grid.size", 5);
            } else {
                object.showStatus("No active grid - using default grid.");
                n = object.getProperties().getIntProperty("ch.ifa.draw.grid.size", 5);
            }
            this.fGrid = new Point(n, n);
            pointConstrainer = new GridConstrainer(this.fGrid.x, this.fGrid.y);
        }
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            object = figureEnumeration.nextFigure();
            cloneable = object.center();
            Point point = pointConstrainer.constrainPoint(object.center());
            object.moveBy(point.x - ((Point)cloneable).x, point.y - ((Point)cloneable).y);
        }
        drawingView.checkDamage();
        return true;
    }
}

