/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.InsertPointHandle;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineConnector;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.figures.PolyLineLocator;
import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.util.BSpline;
import CH.ifa.draw.util.DoublePoint;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.ClassSource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PolyLineFigure
extends AttributeFigure
implements PolyLineable {
    public static Logger logger = Logger.getLogger(PolyLineFigure.class);
    public static final int ARROW_TIP_NONE = 0;
    public static final int ARROW_TIP_START = 1;
    public static final int ARROW_TIP_END = 2;
    public static final int ARROW_TIP_BOTH = 3;
    public static final int LINE_SHAPE = 0;
    public static final int BSPLINE_SHAPE = 1;
    private static final long serialVersionUID = -7951352179906577773L;
    private static Integer BSPLINE_SHAPE_OBJ = new Integer(1);
    protected Vector<Point> fPoints;
    protected transient BSpline spline = null;
    protected LineDecoration fStartDecoration = null;
    protected LineDecoration fEndDecoration = null;
    protected Class<?> fArrowTipClass = ArrowTip.class;
    private int polyLineFigureSerializedDataVersion = 1;

    public PolyLineFigure() {
        this.fPoints = new Vector(4);
    }

    public PolyLineFigure(int n) {
        this.fPoints = new Vector(n);
    }

    public PolyLineFigure(int n, int n2) {
        this.fPoints = new Vector();
        this.fPoints.addElement(new Point(n, n2));
    }

    private boolean drawAsSpline() {
        Object object = this.getAttribute("LineShape");
        return BSPLINE_SHAPE_OBJ.equals(object);
    }

    private Vector<Point> drawPointsVector() {
        if (this.drawAsSpline()) {
            if (this.spline == null) {
                this.updateSpline();
            }
            return this.spline.getCurvepointsInt();
        }
        return this.fPoints;
    }

    private Vector<DoublePoint> drawDoublePointsVector() {
        if (this.drawAsSpline()) {
            if (this.spline == null) {
                this.updateSpline();
            }
            return this.spline.getCurvepointsDouble();
        }
        return DoublePoint.convertPointVector(this.fPoints);
    }

    private void updateSpline() {
        Object object = this.getAttribute("BSplineDegree");
        Object object2 = this.getAttribute("BSplineSegments");
        this.spline = new BSpline(this.fPoints, (Integer)object2, (Integer)object);
    }

    @Override
    public Rectangle displayBox() {
        Enumeration<Point> enumeration = this.points();
        Rectangle rectangle = new Rectangle(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            rectangle.add(enumeration.nextElement());
        }
        return rectangle;
    }

    @Override
    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    protected void addIntermediateHandles(Vector<Handle> vector) {
        int n;
        for (n = 1; n < this.fPoints.size() - 1; ++n) {
            vector.addElement(new PolyLineHandle(this, PolyLineFigure.locator(n), n));
        }
        for (n = 0; n < this.fPoints.size() - 1; ++n) {
            vector.addElement(new InsertPointHandle(this, n));
        }
    }

    @Override
    public Vector<Handle> handles() {
        int n = this.fPoints.size();
        Vector<Handle> vector = new Vector<Handle>(2 * n);
        vector.addElement(new PolyLineHandle(this, PolyLineFigure.locator(0), 0));
        this.addIntermediateHandles(vector);
        vector.addElement(new PolyLineHandle(this, PolyLineFigure.locator(n - 1), n - 1));
        return vector;
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
    }

    public void addPoint(int n, int n2) {
        this.fPoints.addElement(new Point(n, n2));
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    public Enumeration<Point> points() {
        return this.fPoints.elements();
    }

    @Override
    public int pointCount() {
        return this.fPoints.size();
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        Enumeration<Point> enumeration = this.fPoints.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().translate(n, n2);
        }
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
    }

    @Override
    public void setPointAt(Point point, int n) {
        this.willChange();
        this.fPoints.setElementAt(point, n);
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    @Override
    public void insertPointAt(Point point, int n) {
        this.fPoints.insertElementAt(point, n);
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    @Override
    public void removePointAt(int n) {
        if (this.fPoints.size() > 2) {
            this.willChange();
            this.fPoints.removeElementAt(n);
            if (this.spline != null) {
                this.spline.setPoints(this.fPoints);
            }
            this.changed();
        }
    }

    public int splitSegment(int n, int n2) {
        int n3 = this.findSegment(n, n2);
        if (n3 != -1) {
            this.insertPointAt(new Point(n, n2), n3 + 1);
        }
        return n3 + 1;
    }

    @Override
    public Point pointAt(int n) {
        return this.fPoints.elementAt(n);
    }

    public boolean joinSegments(int n, int n2) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            Point point = this.pointAt(i);
            if (Geom.length(n, n2, point.x, point.y) >= 3L) continue;
            this.removePointAt(i);
            return true;
        }
        return false;
    }

    @Override
    public Connector connectorAt(int n, int n2) {
        return new PolyLineConnector(this);
    }

    public void setStartDecoration(LineDecoration lineDecoration) {
        this.fStartDecoration = lineDecoration;
    }

    protected void setStartDecoration() {
        try {
            this.setStartDecoration((LineDecoration)this.fArrowTipClass.newInstance());
        }
        catch (Exception exception) {
            logger.error((Object)("Could not set arrow tip:\n" + String.valueOf(exception)));
        }
    }

    public void setEndDecoration(LineDecoration lineDecoration) {
        this.fEndDecoration = lineDecoration;
    }

    public float distance() {
        Enumeration<Point> enumeration = this.points();
        Point point = enumeration.nextElement();
        float f = 0.0f;
        while (enumeration.hasMoreElements()) {
            Point point2 = enumeration.nextElement();
            f = (float)((double)f + point.distance(point2));
            point = point2;
        }
        return f;
    }

    protected void setEndDecoration() {
        try {
            this.setEndDecoration((LineDecoration)this.fArrowTipClass.newInstance());
        }
        catch (Exception exception) {
            logger.error((Object)("Could not set arrow tip:\n" + String.valueOf(exception)));
        }
    }

    @Override
    public void drawFrame(Graphics graphics) {
        int n;
        Vector<DoublePoint> vector = this.drawDoublePointsVector();
        int n2 = vector.size();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            DoublePoint doublePoint = vector.elementAt(i);
            dArray[i] = doublePoint.x;
            dArray2[i] = doublePoint.y;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)dArray[n], (float)dArray2[n]);
        for (n = 0; n < n2; ++n) {
            generalPath.lineTo((float)dArray[n], (float)dArray2[n]);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Integer n3 = (Integer)this.getAttribute("LineWidth");
        BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
        if (n3 != null) {
            BasicStroke basicStroke2 = new BasicStroke(n3.intValue(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
            graphics2D.setStroke(basicStroke2);
        }
        graphics2D.draw(generalPath);
        if (n3 == null) {
            graphics2D.setStroke(new BasicStroke());
        } else {
            graphics2D.setStroke(new BasicStroke(n3.intValue()));
        }
        this.decorate(graphics);
        graphics2D.setStroke(basicStroke);
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        Rectangle rectangle = this.displayBox();
        rectangle.grow(4, 4);
        if (!rectangle.contains(n, n2)) {
            return false;
        }
        Vector<Point> vector = this.drawPointsVector();
        for (int i = 0; i < vector.size() - 1; ++i) {
            Point point = vector.elementAt(i);
            Point point2 = vector.elementAt(i + 1);
            if (!Geom.lineContainsPoint(point.x, point.y, point2.x, point2.y, n, n2)) continue;
            return true;
        }
        return false;
    }

    private int lineSegment(int n) {
        if (this.drawAsSpline()) {
            return this.spline.lineSegment(n);
        }
        return n;
    }

    public int findSegment(int n, int n2) {
        Vector<Point> vector = this.drawPointsVector();
        for (int i = 0; i < vector.size() - 1; ++i) {
            Point point = vector.elementAt(i);
            Point point2 = vector.elementAt(i + 1);
            if (!Geom.lineContainsPoint(point.x, point.y, point2.x, point2.y, n, n2)) continue;
            return this.lineSegment(i);
        }
        return -1;
    }

    private void decorate(Graphics graphics) {
        Point point;
        Point point2;
        if (this.fStartDecoration != null) {
            point2 = this.fPoints.elementAt(0);
            point = this.fPoints.elementAt(1);
            this.fStartDecoration.draw(graphics, point2.x, point2.y, point.x, point.y, this.getFillColor(), this.getFrameColor());
        }
        if (this.fEndDecoration != null) {
            point2 = this.fPoints.elementAt(this.fPoints.size() - 2);
            point = this.fPoints.elementAt(this.fPoints.size() - 1);
            this.fEndDecoration.draw(graphics, point.x, point.y, point2.x, point2.y, this.getFillColor(), this.getFrameColor());
        }
    }

    @Override
    public Object getAttribute(String string) {
        if (string.equals("ArrowMode")) {
            int n = 0;
            if (this.fStartDecoration != null) {
                n |= 1;
            }
            if (this.fEndDecoration != null) {
                n |= 2;
            }
            return new Integer(n);
        }
        if (string.equals("ArrowTip")) {
            return this.fArrowTipClass.getName();
        }
        return super.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (string.equals("ArrowMode")) {
            Integer n = (Integer)object;
            if (n != null) {
                int n2 = n;
                if ((n2 & 1) != 0) {
                    this.setStartDecoration();
                } else {
                    this.setStartDecoration(null);
                }
                if ((n2 & 2) != 0) {
                    this.setEndDecoration();
                } else {
                    this.setEndDecoration(null);
                }
            }
        } else if (string.equals("ArrowTip")) {
            String string2 = (String)object;
            try {
                this.fArrowTipClass = ClassSource.classForName((String)string2);
                if (this.fStartDecoration != null) {
                    this.setStartDecoration();
                }
                if (this.fEndDecoration != null) {
                    this.setEndDecoration();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error((Object)("Trying to use " + string2 + " for arrow tips:\n" + String.valueOf(classNotFoundException)));
            }
        } else if (string.equals("LineStyle")) {
            String string3 = (String)object;
            if (object != null) {
                super.setAttribute("LineStyle", string3);
            }
        } else {
            if (this.spline != null) {
                if (string.equals("BSplineDegree")) {
                    int n = (Integer)object;
                    this.spline.setDegree(n);
                } else if (string.equals("BSplineSegments")) {
                    int n = (Integer)object;
                    this.spline.setSegments(n);
                }
            }
            super.setAttribute(string, object);
        }
        this.changed();
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fPoints.size());
        Enumeration<Point> enumeration = this.fPoints.elements();
        while (enumeration.hasMoreElements()) {
            Point point = enumeration.nextElement();
            storableOutput.writeInt(point.x);
            storableOutput.writeInt(point.y);
        }
        storableOutput.writeStorable(this.fStartDecoration);
        storableOutput.writeStorable(this.fEndDecoration);
        storableOutput.writeString(this.fArrowTipClass.getName());
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        if (storableInput.getVersion() >= 1) {
            super.read(storableInput);
        }
        int n = storableInput.readInt();
        this.fPoints = new Vector(n);
        for (int i = 0; i < n; ++i) {
            int n2 = storableInput.readInt();
            int n3 = storableInput.readInt();
            this.fPoints.addElement(new Point(n2, n3));
        }
        this.fStartDecoration = (LineDecoration)storableInput.readStorable();
        this.fEndDecoration = (LineDecoration)storableInput.readStorable();
        if (storableInput.getVersion() >= 8) {
            String string = storableInput.readString();
            this.setAttribute("ArrowTip", string);
        }
        if (storableInput.getVersion() == 0) {
            Color color = storableInput.readColor();
            this.setAttribute("FrameColor", color);
        }
    }

    public static Locator locator(int n) {
        return new PolyLineLocator(n);
    }
}

