/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.xml;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.xml.GraphicsParseState;
import de.renew.gui.xml.IgnoreElementState;
import de.renew.gui.xml.InscriptionState;
import de.renew.gui.xml.NetParseState;
import de.renew.gui.xml.ParseState;
import java.awt.Color;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

abstract class NodeParseState
implements ParseState {
    private static Logger logger = Logger.getLogger(NodeParseState.class);
    NetParseState env;
    AttributeFigure figure;

    NodeParseState(NetParseState netParseState, Attributes attributes) {
        this.env = netParseState;
        this.figure = this.createFigure();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.processAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(NodeParseState.class.getSimpleName() + ": add figure " + this.figure.getClass().getSimpleName()));
        }
        netParseState.drawing.add((Figure)this.figure);
    }

    abstract AttributeFigure createFigure();

    void attachErrorFigure(String string) {
        TextFigure textFigure = new TextFigure();
        textFigure.setAttribute("FillColor", (Object)Color.red);
        textFigure.setText(string);
        textFigure.setParent((ParentFigure)this.figure);
        this.env.drawing.add((Figure)textFigure);
    }

    public static int parseID(String string) {
        return Integer.parseInt(string.substring(1));
    }

    void processAttribute(String string, String string2) {
        if ("id".equals(string)) {
            this.figure.setID(NodeParseState.parseID(string2));
        } else if ("type".equals(string)) {
            if (!"ordinary".equals(string2)) {
                this.attachErrorFigure("Unknown type: " + string2);
            }
        } else {
            this.figure.setAttribute("XRNA" + string, (Object)string2);
        }
    }

    @Override
    public ParseState startElement(String string, Attributes attributes) {
        if ("annotation".equals(string)) {
            CPNTextFigure cPNTextFigure = new CPNTextFigure(1);
            cPNTextFigure.setParent((ParentFigure)this.figure);
            return new InscriptionState(this, (TextFigure)cPNTextFigure, this.env.drawing, attributes, false);
        }
        if ("graphics".equals(string)) {
            return new GraphicsParseState(this, this.figure);
        }
        return new IgnoreElementState(this);
    }

    @Override
    public ParseState endElement(String string) {
        return this.env;
    }

    @Override
    public ParseState characters(char[] cArray, int n, int n2) {
        return this;
    }
}

