/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.framework.Figure;
import de.renew.gui.CPNDrawingView;
import de.renew.gui.CPNTextFigure;
import de.renew.refactoring.inline.InlineControllerWithListener;
import de.renew.refactoring.inline.InlineStep;
import de.renew.refactoring.inline.InlineStepListener;
import de.renew.refactoring.inline.PopupMenuStep;
import de.renew.refactoring.inline.RestrictedEditingTextFieldStep;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.renamevariable.NoVariableSelectedException;
import de.renew.refactoring.renamevariable.RenameVariableRefactoring;
import de.renew.refactoring.renamevariable.Variable;
import de.renew.refactoring.renamevariable.VariableNameMatch;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class RenameVariableInlineController
extends InlineControllerWithListener {
    private static Logger logger = Logger.getLogger(RenameVariableInlineController.class);
    private State _state = State.STARTED;
    private final RenameVariableRefactoring _refactoring;
    private final CPNDrawingView _container;
    private RestrictedEditingTextFieldStep _textFieldStep;
    private Vector<Figure> _referencingFigures;

    public RenameVariableInlineController(VariableParser variableParser, CPNDrawingView cPNDrawingView) throws NoVariableSelectedException {
        this._container = cPNDrawingView;
        this._refactoring = new RenameVariableRefactoring(variableParser, cPNDrawingView.drawing(), cPNDrawingView.selection());
        this.nextStep();
    }

    @Override
    public InlineStep nextStep() {
        if (this._state == State.STARTED) {
            ArrayList<Variable> arrayList = new ArrayList<Variable>(this._refactoring.getVariablesInSelection());
            if (arrayList.size() == 1) {
                this._refactoring.setSelectedVariable((Variable)arrayList.get(0));
                this._state = State.SELECTED_VARIABLE;
            } else {
                Point point = this._refactoring.getSelectedTextFigure().center();
                Collections.sort(arrayList);
                return this.makeSelectVariableStep(point, arrayList);
            }
        }
        if (this._state == State.SELECTED_VARIABLE) {
            this._state = State.RENAMING;
            this._refactoring.findReferences();
            this._textFieldStep = this.makeEditVariableNameStep();
            return this._textFieldStep;
        }
        if (this._state == State.RENAMING) {
            this._state = State.FINISHED;
            this._textFieldStep.endEdit();
            this._textFieldStep = null;
            if (!this._refactoring.enteredValidVariableName()) {
                this._refactoring.restorePreviousTexts();
            }
            this._container.selection().removeAll(this._referencingFigures);
            this._container.checkDamage();
            this.informListenersFinished();
        }
        return null;
    }

    private PopupMenuStep<Variable> makeSelectVariableStep(Point point, List<Variable> list) {
        PopupMenuStep<Variable> popupMenuStep = new PopupMenuStep<Variable>((Container)this._container, point, list){

            @Override
            public String titleForEntry(Variable variable) {
                return "Rename " + String.valueOf(variable);
            }

            @Override
            public ActionListener actionListenerForEntry(Variable variable) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RenameVariableInlineController.this._state = State.SELECTED_VARIABLE;
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        Variable variable = (Variable)this.getEntryForMenuItem(jMenuItem);
                        RenameVariableInlineController.this._refactoring.setSelectedVariable(variable);
                        RenameVariableInlineController.this.nextStep();
                    }
                };
            }
        };
        popupMenuStep.addListener(new InlineStepListener(){

            @Override
            public void inlineStepFinished() {
            }

            @Override
            public void inlineStepCancelled() {
                RenameVariableInlineController.this.informListenersFinished();
            }
        });
        return popupMenuStep;
    }

    private RestrictedEditingTextFieldStep makeEditVariableNameStep() {
        StringMatch stringMatch = this._refactoring.getSelectedVariableStringMatch();
        CPNTextFigure cPNTextFigure = this._refactoring.getSelectedTextFigure();
        this._referencingFigures = new Vector();
        for (VariableNameMatch variableNameMatch : this._refactoring.getReferences()) {
            this._referencingFigures.add((Figure)variableNameMatch.getTextFigure());
        }
        this._container.addToSelectionAll(this._referencingFigures);
        this._container.checkDamage();
        return new RestrictedEditingTextFieldStep((Container)this._container, cPNTextFigure, stringMatch){

            @Override
            public void editedTextChanged(String string) {
                RenameVariableInlineController.this._refactoring.setNewName(string);
                RenameVariableInlineController.this.updateTextFieldBorderColor();
                RenameVariableInlineController.this._refactoring.restorePreviousTexts();
                RenameVariableInlineController.this._refactoring.replaceVariables();
            }

            @Override
            protected KeyListener textFieldKeyListener() {
                return new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10 && RenameVariableInlineController.this._refactoring.enteredValidVariableName()) {
                            RenameVariableInlineController.this.nextStep();
                        }
                    }
                };
            }

            @Override
            protected MouseListener containerMouseListener() {
                return new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (RenameVariableInlineController.this._state == State.RENAMING) {
                            RenameVariableInlineController.this.nextStep();
                        }
                    }
                };
            }
        };
    }

    private void updateTextFieldBorderColor() {
        Color color;
        Color color2 = color = this._refactoring.enteredValidVariableName() ? Color.BLACK : Color.RED;
        if (this._textFieldStep != null) {
            this._textFieldStep.setBorderColor(color);
        }
    }

    private static enum State {
        STARTED,
        SELECTED_VARIABLE,
        RENAMING,
        FINISHED;

    }
}

