/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.commands.CheckVerificationRequestCommand;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class CheckAllTasksCommand
extends Command
implements CLCommand {
    private String lolaPath;
    private static Logger logger = Logger.getLogger(CheckVerificationRequestCommand.class);

    public CheckAllTasksCommand(String string, String string2) {
        super(string);
        this.lolaPath = string2;
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        Drawing drawing = drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawing);
        if (!(drawing instanceof CPNDrawing)) {
            logger.error((Object)"[Lola] Drawing needs to be a CPNDrawing. Aborting.");
            return;
        }
        FigureEnumeration figureEnumeration = drawing.figures();
        Boolean bl = false;
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (figure instanceof TextFigure) {
                TextFigure textFigure = (TextFigure)figure;
                String string = textFigure.getText();
                if (!string.toLowerCase().startsWith("formula")) continue;
                LolaTask lolaTask = new LolaTask((TextFigure)figure, (CPNDrawing)drawing);
                lolaTask.check(new LolaAnalyzer(this.lolaPath));
                lolaTask.colorFigure();
                figure.changed();
                bl = true;
                continue;
            }
            logger.info((Object)"[Lola] Currently only checking TextFigures.");
        }
        if (bl.booleanValue()) {
            DrawPlugin.getGui().view().checkDamage();
            drawApplication.getUndoRedoManager().commitUndoSnapshot(drawing);
        }
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return null;
    }
}

