/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.analysis;

import de.renew.lola2.LolaPlugin;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.LolaHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LolaAnalyzer {
    private static Logger logger = Logger.getLogger(LolaAnalyzer.class);
    public static final int TIMEOUT = 5;
    protected String lolaPath;

    public LolaAnalyzer() {
        this.lolaPath = LolaPlugin.getLolaPath();
    }

    public LolaAnalyzer(String string) {
        this.lolaPath = string;
    }

    public DirectLolaResult callLola(String string, File file) {
        return this.callLola(string, file, new String[0]);
    }

    public DirectLolaResult callLola(String string, File file, String[] stringArray) {
        Object object;
        Runtime runtime = Runtime.getRuntime();
        File file2 = new File(this.lolaPath, "lola");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("LolaAnalyzer.callLola: lolaBin, netFile, formula, parameter are " + String.valueOf(file2) + " " + String.valueOf(file) + " " + string + " " + String.valueOf(stringArray)));
        }
        File file3 = null;
        try {
            file3 = File.createTempFile("lolaoutput", ".json", LolaHelper.findTmpDir());
        }
        catch (IOException iOException) {
            logger.error((Object)"[Lola] Could not create temporary file for JSON output");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(file2.toString());
        arrayList.add(file.toString());
        arrayList.add("--timelimit=5");
        arrayList.add("--json=" + file3.getAbsolutePath());
        if (string != null) {
            arrayList.add("--formula=" + string);
        }
        arrayList.addAll(Arrays.asList(stringArray));
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[Lola] Executing " + this.renderCommand(stringArray2)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 1;
        try {
            object = runtime.exec(stringArray2);
            n = ((Process)object).waitFor();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file3));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(((Process)object).getErrorStream()));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append(System.lineSeparator());
                logger.debug((Object)("[callLola OUTPUT]" + string2));
            }
            while ((string2 = bufferedReader2.readLine()) != null) {
                stringBuilder2.append(string2);
                stringBuilder2.append(System.lineSeparator());
                logger.debug((Object)("[callLola ERROR]" + string2));
            }
            logger.debug((Object)("[Lola] Call returned exit value " + n));
            bufferedReader.close();
            bufferedReader2.close();
        }
        catch (IOException iOException) {
            logger.error((Object)"[Lola] Execution failed");
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"[Lola] Execution interrupted");
            interruptedException.printStackTrace();
        }
        object = new DirectLolaResult(n, stringBuilder.toString(), stringBuilder2.toString());
        return object;
    }

    private String renderCommand(String[] stringArray) {
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2 = stringArray[i];
            if (((String)object2).contains(" ")) {
                object2 = "\"" + (String)object2 + "\"";
            }
            object = (String)object + (String)object2;
            if (i >= stringArray.length - 1) continue;
            object = (String)object + " ";
        }
        return object;
    }
}

