/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import java.awt.Color;
import java.io.File;
import org.apache.log4j.Logger;

public class LolaTask {
    private static Logger logger = Logger.getLogger(LolaTask.class);
    private String _text;
    private String _formula;
    private DirectLolaResult _result;
    private final TextFigure _figure;
    private final CPNDrawing _drawing;

    public LolaTask(TextFigure textFigure, CPNDrawing cPNDrawing) {
        this._figure = textFigure;
        this._drawing = cPNDrawing;
        this._text = textFigure.getText();
        this._formula = this.parseText(this._text);
    }

    private String parseText(String string) {
        String string2 = null;
        if (string.toLowerCase().startsWith("formula")) {
            string2 = string.substring("formula".length()).trim();
        }
        return string2;
    }

    public DirectLolaResult check(LolaAnalyzer lolaAnalyzer) {
        File file = new LolaFileCreator().writeTemporaryLolaFile(this._drawing);
        this._result = lolaAnalyzer.callLola(this._formula, file);
        return this._result;
    }

    public void colorFigure() {
        if (this._result != null) {
            Color color = LolaGUIHelper.getStatusColor(this._result.getStatus());
            this._figure.setAttribute("FrameColor", (Object)color);
        } else {
            logger.error((Object)"[Lola Task] Task seems to be not yet checked.");
        }
    }

    public void resetColor() {
        this._figure.setAttribute("FrameColor", (Object)ColorMap.NONE);
    }

    public String toString() {
        return this._formula;
    }

    public TextFigure getFigure() {
        return this._figure;
    }
}

