/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.gui.LolaGUI;
import de.renew.lola2.gui.LolaGUIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class TasksPanel
extends JPanel {
    private LolaGUI lolaGUI;
    private static Logger logger = Logger.getLogger(TasksPanel.class);
    private JTable _taskTable;
    protected String newTaskText = "";
    private static final Vector<String> taskColumnNames = new Vector();

    public TasksPanel(LolaGUI lolaGUI) {
        taskColumnNames.add("Result");
        taskColumnNames.add("Verification Task");
        this.lolaGUI = lolaGUI;
        this.setVisible(true);
        this.setup();
    }

    private void setup() {
        this._taskTable = new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.setupTaskTable();
        JScrollPane jScrollPane = new JScrollPane(this._taskTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        final JTextField jTextField = new JTextField(20);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TasksPanel.this.newTaskText = jTextField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TasksPanel.this.newTaskText = jTextField.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jTextField.setToolTipText("<html>Input new verification task here and click the add button.<br>(some pointer on syntax should go here) <br><i>There is no syntax check so far.</i></html> ");
        JButton jButton = new JButton("Add task");
        jButton.setToolTipText("Add the entered task to the list");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TasksPanel.this.newTaskText != "") {
                    logger.info((Object)("[Lola GUI] Adding Task: " + TasksPanel.this.newTaskText));
                    if (!TasksPanel.this.newTaskText.toLowerCase().startsWith("formula")) {
                        TasksPanel.this.newTaskText = "FORMULA " + TasksPanel.this.newTaskText;
                    }
                    TextFigure textFigure = new TextFigure(false);
                    textFigure.setText(TasksPanel.this.newTaskText);
                    TasksPanel.this.lolaGUI.drawing.add((Figure)textFigure);
                    TasksPanel.this.lolaGUI.drawing.checkDamage();
                    LolaTask lolaTask = new LolaTask(textFigure, TasksPanel.this.lolaGUI.drawing);
                    Vector<Object> vector = new Vector<Object>();
                    vector.add(new IndirectLolaResult(LolaResultStatus.UNCHECKED));
                    vector.add(lolaTask);
                    ((DefaultTableModel)TasksPanel.this._taskTable.getModel()).addRow(vector);
                } else {
                    logger.error((Object)"[Lola GUI] No text, no task to add.");
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add(jTextField);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Update Tasks");
        jButton2.setAlignmentX(0.5f);
        jButton2.setToolTipText("Parses the tasks in the current net drawing and displays them in the table.");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LolaFileCreator lolaFileCreator = new LolaFileCreator();
                Vector<LolaTask> vector = lolaFileCreator.parseTasks(TasksPanel.this.lolaGUI.drawing);
                DefaultTableModel defaultTableModel = new DefaultTableModel();
                defaultTableModel.addColumn((Object)"task", vector);
                defaultTableModel.addColumn((Object)"result", new Vector());
                defaultTableModel.setColumnIdentifiers(taskColumnNames);
                TasksPanel.this._taskTable.setModel(defaultTableModel);
                TasksPanel.this.setupTaskTable();
            }
        });
        JButton jButton3 = new JButton("Check Tasks");
        jButton3.setAlignmentX(0.5f);
        jButton3.setToolTipText("Checks the selected tasks and displays the result.");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < TasksPanel.this._taskTable.getRowCount(); ++i) {
                    LolaTask lolaTask = (LolaTask)TasksPanel.this._taskTable.getValueAt(i, 1);
                    logger.info((Object)("[Lola TaskCheck] checking task " + lolaTask.toString()));
                    DirectLolaResult directLolaResult = lolaTask.check(new LolaAnalyzer(TasksPanel.this.lolaGUI.lolaPath));
                    lolaTask.colorFigure();
                    TasksPanel.this._taskTable.setValueAt(directLolaResult, i, 0);
                }
                TasksPanel.this.lolaGUI.drawing.checkDamage();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton3);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "First");
        this.add((Component)jPanel2, "Last");
    }

    private void setupTaskTable() {
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        if (this.lolaGUI.drawing == null) {
            System.out.println("DRAWING IS NULL");
        }
        Vector<LolaTask> vector = lolaFileCreator.parseTasks(this.lolaGUI.drawing);
        Collections.sort(vector, new Comparator<LolaTask>(){

            @Override
            public int compare(LolaTask lolaTask, LolaTask lolaTask2) {
                Rectangle rectangle = lolaTask.getFigure().displayBox();
                Rectangle rectangle2 = lolaTask2.getFigure().displayBox();
                int n = rectangle.x == rectangle2.x && rectangle.y == rectangle2.y ? lolaTask.toString().compareTo(lolaTask2.toString()) : (rectangle.y > rectangle2.y || rectangle.y == rectangle2.y && rectangle.x > rectangle2.x ? 1 : -1);
                return n;
            }
        });
        Vector<IndirectLolaResult> vector2 = new Vector<IndirectLolaResult>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(new IndirectLolaResult(LolaResultStatus.UNCHECKED));
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn((Object)"result", vector2);
        defaultTableModel.addColumn((Object)"task", vector);
        defaultTableModel.setColumnIdentifiers(taskColumnNames);
        this._taskTable.setModel(defaultTableModel);
        this._taskTable.setFillsViewportHeight(true);
        this._taskTable.setRowHeight(20);
        this._taskTable.setIntercellSpacing(new Dimension(4, 4));
        this._taskTable.getColumnModel().getColumn(1).setPreferredWidth(350);
        this._taskTable.getColumnModel().getColumn(1).setMinWidth(350);
        this._taskTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer());
        this._taskTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this._taskTable.getColumnModel().getColumn(0).setMinWidth(20);
        this._taskTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                if (object instanceof LolaResult) {
                    Serializable serializable;
                    LolaResult lolaResult = (LolaResult)object;
                    LolaResultStatus lolaResultStatus = lolaResult.getStatus();
                    this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                    this.setText(lolaResultStatus.toString().substring(0, 1));
                    if (lolaResult instanceof DirectLolaResult) {
                        serializable = new StringBuffer("<html>");
                        DirectLolaResult directLolaResult = (DirectLolaResult)lolaResult;
                        String string = directLolaResult.getError();
                        ((StringBuffer)serializable).append(string.replaceAll("\n", "\n<br>"));
                        ((StringBuffer)serializable).append("</html>");
                        this.setToolTipText(((StringBuffer)serializable).toString());
                    } else {
                        this.setToolTipText("No Output available.");
                    }
                    serializable = LolaGUIHelper.getStatusColor(lolaResultStatus);
                    this.setBackground((Color)serializable);
                } else {
                    logger.error((Object)"[Lola GUI] This should use other renderer.");
                    super.setValue(object);
                }
            }
        });
    }
}

