/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.commands.CheckAllCommand;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CheckSelectedPlaceCommand
extends Command
implements CLCommand {
    private String lolaPath;
    private static Logger logger = Logger.getLogger(CheckSelectedPlaceCommand.class);

    public CheckSelectedPlaceCommand(String string, String string2) {
        super(string);
        this.lolaPath = string2;
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        CPNDrawing cPNDrawing = (CPNDrawing)drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawApplication.drawing());
        Vector vector = drawApplication.view().selection();
        PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(this.lolaPath);
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        File file = lolaFileCreator.writeTemporaryLolaFile(cPNDrawing);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + file.getPath()));
        }
        for (Figure figure : vector) {
            String string;
            DirectLolaResult directLolaResult;
            if (!(figure instanceof PlaceFigure) || figure instanceof VirtualPlaceFigure || (directLolaResult = propertyAnalyzer.checkPlaceBoundedness(string = lolaFileCreator.getNameForFigure(figure), file)) == null) continue;
            switch (directLolaResult.getStatus()) {
                case YES: {
                    LolaGUIHelper.colorFigure(figure, Color.GREEN);
                    break;
                }
                case NO: {
                    LolaGUIHelper.colorFigure(figure, Color.RED);
                    break;
                }
            }
        }
        drawApplication.getUndoRedoManager().commitUndoSnapshot(drawApplication.drawing());
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return "Check if the selected place is bounded";
    }
}

