/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.commands.CheckAllCommand;
import java.io.File;
import org.apache.log4j.Logger;

public class CheckLivenessCommand
extends Command {
    private String lolaPath;
    private static Logger logger = Logger.getLogger(CheckLivenessCommand.class);

    public CheckLivenessCommand(String string, String string2) {
        super(string);
        this.lolaPath = string2;
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        CPNDrawing cPNDrawing = (CPNDrawing)drawApplication.drawing();
        PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(this.lolaPath);
        File file = new LolaFileCreator().writeTemporaryLolaFile(cPNDrawing);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + file.getPath()));
        }
        IndirectLolaResult indirectLolaResult = propertyAnalyzer.checkNetLiveness(file, true);
        switch (indirectLolaResult.getStatus()) {
            case YES: {
                logger.info((Object)"YES, net is live.");
                break;
            }
            case NO: {
                logger.info((Object)"NO, net is not live.");
                break;
            }
            default: {
                logger.info((Object)("Unspecified result for liveness: " + String.valueOf((Object)indirectLolaResult.getStatus())));
            }
        }
    }
}

