/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.analysis;

import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DirectLolaResult
implements LolaResult {
    private static Logger logger = Logger.getLogger(DirectLolaResult.class);
    private String output;
    private String error;
    private LolaResultStatus status;

    public DirectLolaResult(int n, String string, String string2) {
        this.output = string;
        this.error = string2;
        this.status = this.checkResultStatus(n, string);
    }

    private LolaResultStatus checkResultStatus(int n, String string) {
        LolaResultStatus lolaResultStatus;
        block5: {
            lolaResultStatus = null;
            if (n == 0) {
                JSONParser jSONParser = new JSONParser();
                try {
                    Optional<Boolean> optional = Optional.of(jSONParser.parse(string)).filter(JSONObject.class::isInstance).map(JSONObject.class::cast).filter(jSONObject -> jSONObject.containsKey((Object)"analysis")).map(jSONObject -> jSONObject.get((Object)"analysis")).filter(JSONObject.class::isInstance).map(JSONObject.class::cast).filter(jSONObject -> jSONObject.containsKey((Object)"result")).map(jSONObject -> jSONObject.get((Object)"result")).filter(Boolean.class::isInstance).map(Boolean.class::cast);
                    if (optional.isPresent()) {
                        lolaResultStatus = optional.get() != false ? LolaResultStatus.YES : LolaResultStatus.NO;
                        break block5;
                    }
                    lolaResultStatus = LolaResultStatus.ERROR;
                    logger.error((Object)"Could not extract LoLA result from JSON output.");
                }
                catch (ParseException parseException) {
                    lolaResultStatus = LolaResultStatus.ERROR;
                    logger.error((Object)"Could not parse LoLA JSON output.");
                }
            } else {
                lolaResultStatus = LolaResultStatus.ERROR;
                logger.error((Object)"LoLA call returned an error.");
            }
        }
        return lolaResultStatus;
    }

    public String getOutput() {
        return this.output;
    }

    public String getError() {
        return this.error;
    }

    @Override
    public LolaResultStatus getStatus() {
        return this.status;
    }
}

