/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola.LolaHelper;
import de.renew.lola.LolaTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LolaFileCreator {
    private static Logger logger = Logger.getLogger(LolaFileCreator.class);
    private HashMap<Figure, String> usedFigureNames = new HashMap();
    protected HashMap<TransitionFigure, HashMap<PlaceFigure, Integer>> preAll = new HashMap();
    protected HashMap<TransitionFigure, HashMap<PlaceFigure, Integer>> postAll = new HashMap();
    private boolean ptnetcompiler;

    public void writeLolaFile(OutputStream outputStream, CPNDrawing cPNDrawing) {
        this.writeLolaFile(outputStream, cPNDrawing, new StringBuffer(""));
    }

    public LolaFileCreator() {
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        if (formalismPlugin != null) {
            String string = formalismPlugin.getCompiler();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[Lola] Using compiler: " + string));
                if (string.equals("P/T Net Compiler")) {
                    this.ptnetcompiler = true;
                }
            }
        } else {
            this.ptnetcompiler = true;
        }
    }

    public void writeLolaFile(OutputStream outputStream, CPNDrawing cPNDrawing, StringBuffer stringBuffer) {
        if (this.emptyNet(cPNDrawing)) {
            logger.error((Object)"[Lola Export] Net drawing needs at least 1 place and 1 transition.");
            return;
        }
        logger.info((Object)"[Lola Export] Converting drawing to lola net file format");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Extracting Places");
        }
        StringBuffer stringBuffer2 = this.extractPlaces(cPNDrawing);
        StringBuffer stringBuffer3 = stringBuffer;
        if (stringBuffer.toString().equals("")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"  Extracting Marking");
            }
            stringBuffer3 = this.extractMarking(cPNDrawing);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Extracting Transitions");
        }
        StringBuffer stringBuffer4 = this.extractTransitions(cPNDrawing);
        try {
            outputStream.write(stringBuffer2.toString().getBytes());
            outputStream.write(stringBuffer3.toString().getBytes());
            outputStream.write(stringBuffer4.toString().getBytes());
        }
        catch (IOException iOException) {
            logger.error((Object)"[Lola] Writing to output stream failed");
            iOException.printStackTrace();
        }
    }

    private boolean emptyNet(CPNDrawing cPNDrawing) {
        int n = 0;
        int n2 = 0;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (figure instanceof PlaceFigure) {
                ++n;
            }
            if (!(figure instanceof TransitionFigure)) continue;
            ++n2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] Net " + cPNDrawing.getName() + " has " + n + " Places and " + n2 + " Transitions"));
        }
        return n < 1 || n2 < 1;
    }

    public static File writeTemporaryLolaFile(CPNDrawing cPNDrawing) {
        return LolaFileCreator.writeTemporaryLolaFile(cPNDrawing, new StringBuffer(""));
    }

    public static File writeTemporaryLolaFile(CPNDrawing cPNDrawing, StringBuffer stringBuffer) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        String string = cPNDrawing.getName();
        try {
            file = File.createTempFile("renew" + string, ".net", LolaHelper.findTmpDir());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[Lola] temporay lola net file: " + file.getAbsolutePath()));
            }
            fileOutputStream = new FileOutputStream(file);
            lolaFileCreator.writeLolaFile(fileOutputStream, cPNDrawing, stringBuffer);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)"[Lola] Could not create stream to write lola file");
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.error((Object)("[Lola] Could not create temporary lola file in directory " + String.valueOf(LolaHelper.findTmpDir())));
            iOException.printStackTrace();
        }
        return file;
    }

    public void createTasks(CPNDrawing cPNDrawing, File file) {
        logger.info((Object)"[Lola] Start writing task files");
        logger.info((Object)"[Lola] Extracting ANALYSE MARKING Tasks");
        String string = file.getAbsolutePath();
        String string2 = string.substring(0, string.lastIndexOf(".net"));
        HashMap<String, ArrayList<String>> hashMap = this.extractAllTasks(cPNDrawing);
        for (String string3 : hashMap.keySet()) {
            ArrayList<String> arrayList = hashMap.get(string3);
            if (arrayList == null) continue;
            this.writeTaskFiles(string2, arrayList, LolaHelper.taskFilenameMap.get(string3));
        }
    }

    public File writeTaskFile(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("LolaFileCreator.writeTaskFile: Writing single task to " + string));
        }
        ArrayList<File> arrayList2 = this.writeTaskFiles(string, arrayList, string3);
        return arrayList2.get(0);
    }

    private ArrayList<File> writeTaskFiles(String string, ArrayList<String> arrayList, String string2) {
        ArrayList<File> arrayList2 = new ArrayList<File>();
        int n = 1;
        for (String string3 : arrayList) {
            String string4 = string + string2 + n + ".task";
            logger.info((Object)("[Lola] Write task to file: " + string4));
            logger.info((Object)("[Lola] Task Text: " + string3));
            File file = new File(string4);
            arrayList2.add(file);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(string3.getBytes());
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)"[Lola] Creating file output stream failed");
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                logger.error((Object)"[Lola] Writing to file output stream failed");
                iOException.printStackTrace();
            }
            ++n;
        }
        return arrayList2;
    }

    public String parseTask(TextFigure textFigure) {
        String string = "";
        String string2 = textFigure.getText();
        logger.debug((Object)("[Lola] Parsing verification task " + string2));
        if (textFigure.parent() == null) {
            if (string2.startsWith("ANALYSE MARKING")) {
                string = LolaHelper.taskFilenameMap.get("ANALYSE MARKING");
            } else if (string2.startsWith("ANALYSE TRANSITION")) {
                string = "Transition";
            } else if (string2.startsWith("ANALYSE PLACE")) {
                string = "Place";
            } else if (string2.startsWith("FORMULA")) {
                string = LolaHelper.ctlp(string2).booleanValue() ? "CTL" : "StatePredicate";
            } else {
                logger.error((Object)"[Lola] Didn't recognize the type of the task.");
            }
        }
        return string;
    }

    private HashMap<String, ArrayList<String>> extractAllTasks(CPNDrawing cPNDrawing) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put("ANALYSE MARKING", new ArrayList());
        hashMap.put("ANALYSE PLACE", new ArrayList());
        hashMap.put("ANALYSE TRANSITION", new ArrayList());
        hashMap.put("STATE PREDICATE FORMULA", new ArrayList());
        hashMap.put("CTL FORMULA", new ArrayList());
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof TextFigure)) continue;
            String string = ((TextFigure)figure).getText();
            if (string.startsWith("ANALYSE MARKING")) {
                hashMap.get("ANALYSE MARKING").add(string);
            }
            if (string.startsWith("ANALYSE TRANSITION")) {
                hashMap.get("ANALYSE TRANSITION").add(string);
            }
            if (string.startsWith("ANALYSE PLACE")) {
                hashMap.get("ANALYSE PLACE").add(string);
            }
            if (string.startsWith("FORMULA")) {
                if (LolaHelper.ctlp(string).booleanValue()) {
                    hashMap.get("CTL FORMULA").add(string);
                } else {
                    hashMap.get("STATE PREDICATE FORMULA").add(string);
                }
            }
            if (!string.startsWith("ASSERT")) continue;
            ParentFigure parentFigure = ((TextFigure)figure).parent();
            String string2 = this.name((FigureWithID)parentFigure);
            Object object = "";
            if (parentFigure instanceof PlaceFigure) {
                object = "ANALYSE PLACE " + string2;
                hashMap.get("ANALYSE PLACE").add((String)object);
            } else if (parentFigure instanceof TransitionFigure) {
                object = "ANALYSE TRANSITION " + string2;
                hashMap.get("ANALYSE TRANSITION").add((String)object);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[Lola] Export: Found assert task: " + (String)object));
        }
        return hashMap;
    }

    private StringBuffer extractTransitions(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = false;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Object object;
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof TransitionFigure)) continue;
            TransitionFigure transitionFigure = (TransitionFigure)figure;
            stringBuffer.append("TRANSITION " + this.name((FigureWithID)transitionFigure) + "{x:" + (int)transitionFigure.displayBox().getX() + "y:" + (int)transitionFigure.displayBox().getY() + "}\n");
            HashMap<String, Integer> hashMap = this.preset((Drawing)cPNDrawing, transitionFigure);
            stringBuffer.append("CONSUME\n  ");
            bl = false;
            Object object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                if (bl.booleanValue()) {
                    stringBuffer.append(",\n  ");
                } else {
                    bl = true;
                }
                object = object2.next();
                stringBuffer.append((String)object + ": " + String.valueOf(hashMap.get(object)));
            }
            stringBuffer.append(";\n\n");
            object2 = this.postset((Drawing)cPNDrawing, transitionFigure);
            stringBuffer.append("PRODUCE\n  ");
            bl = false;
            object = ((HashMap)object2).keySet().iterator();
            while (object.hasNext()) {
                if (bl.booleanValue()) {
                    stringBuffer.append(",\n  ");
                } else {
                    bl = true;
                }
                String string = (String)object.next();
                stringBuffer.append(string + ": " + String.valueOf(((HashMap)object2).get(string)));
            }
            stringBuffer.append(";\n\n");
        }
        return stringBuffer;
    }

    private StringBuffer extractMarking(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = false;
        stringBuffer.append("MARKING\n");
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof PlaceFigure)) continue;
            PlaceFigure placeFigure = (PlaceFigure)figure;
            if (logger.isDebugEnabled() && placeFigure instanceof VirtualPlaceFigure) {
                logger.debug((Object)("[Lola Export] Place " + this.name((FigureWithID)placeFigure) + " is virtual.\n It is not allowed that both virtual and original place are marked."));
            }
            FigureEnumeration figureEnumeration2 = placeFigure.children();
            StringBuffer stringBuffer2 = new StringBuffer();
            Boolean bl2 = false;
            int n = 0;
            stringBuffer2.append(bl != false ? ",\n  " : "  ");
            stringBuffer2.append(placeFigure instanceof VirtualPlaceFigure ? this.name((FigureWithID)placeFigure.getSemanticPlaceFigure()) : this.name((FigureWithID)placeFigure));
            stringBuffer2.append(": ");
            while (figureEnumeration2.hasMoreElements()) {
                Figure figure2 = figureEnumeration2.nextFigure();
                if (!(figure2 instanceof CPNTextFigure)) continue;
                String string = ((CPNTextFigure)figure2).getText();
                if (((CPNTextFigure)figure2).getType() != 1) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[Lola Export: Extract Marking] Place " + this.name((FigureWithID)placeFigure) + " has inscription " + string));
                }
                if (this.ptnetcompiler) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(LolaFileCreator.class.getSimpleName() + ": Encountered ptnetcomp and number: " + string));
                    }
                    n = string.matches("^[0-9]*$") ? n + Integer.parseInt(string) : n + 1;
                } else {
                    ++n;
                }
                bl2 = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Lola Export: Extract Marking] Place " + this.name((FigureWithID)placeFigure) + " has " + n + " token."));
            }
            stringBuffer2.append(n);
            if (!bl2.booleanValue()) continue;
            bl = true;
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append(";\n\n");
        return stringBuffer;
    }

    private StringBuffer extractPlaces(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PLACE\n");
        boolean bl = false;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof PlaceFigure) || figure instanceof VirtualPlaceFigure) continue;
            if (bl) {
                stringBuffer.append(",\n");
            } else {
                bl = true;
            }
            PlaceFigure placeFigure = (PlaceFigure)figure;
            stringBuffer.append("  " + this.name((FigureWithID)placeFigure) + "{x:" + (int)placeFigure.displayBox().getX() + "y:" + (int)placeFigure.displayBox().getY() + "}");
        }
        stringBuffer.append(";\n\n");
        return stringBuffer;
    }

    private HashMap<String, Integer> preset(Drawing drawing, TransitionFigure transitionFigure) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            String string;
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof ArcConnection)) continue;
            ArcConnection arcConnection = (ArcConnection)figure;
            Integer n = arcConnection.getArcType();
            Figure figure2 = arcConnection.endFigure();
            Figure figure3 = arcConnection.startFigure();
            if (figure2.equals(transitionFigure) && figure3 instanceof PlaceFigure) {
                string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure3));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, this.parseArcInscription(arcConnection));
                    continue;
                }
                hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
                continue;
            }
            if (!figure3.equals(transitionFigure) || n != 0 && n != 2 || !(figure2 instanceof PlaceFigure)) continue;
            string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure2));
            if (hashMap.get(string) == null) {
                hashMap.put(string, this.parseArcInscription(arcConnection));
                continue;
            }
            hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola Export] Preset of " + this.name((FigureWithID)transitionFigure) + " is: " + hashMap.toString()));
        }
        return hashMap;
    }

    private PlaceFigure unvirtualize(PlaceFigure placeFigure) {
        return placeFigure instanceof VirtualPlaceFigure ? placeFigure.getSemanticPlaceFigure() : placeFigure;
    }

    private Integer parseArcInscription(ArcConnection arcConnection) {
        Integer n = 1;
        boolean bl = false;
        int n2 = 0;
        FilteredFigureEnumerator filteredFigureEnumerator = new FilteredFigureEnumerator(arcConnection.children(), new FigureFilter(){

            public boolean isUsed(Figure figure) {
                return figure instanceof CPNTextFigure && ((CPNTextFigure)figure).getType() == 1;
            }
        });
        while (filteredFigureEnumerator.hasMoreElements()) {
            bl = true;
            Figure figure = filteredFigureEnumerator.nextFigure();
            String string = ((TextFigure)figure).getText();
            if (this.ptnetcompiler) {
                int n3 = string.matches("^[0-9]*$") ? Integer.parseInt(string) : 1;
                return n3;
            }
            String[] stringArray = string.split(";");
            String string2 = "";
            for (String string3 : stringArray) {
                if (string3.equals(string2)) continue;
                ++n2;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[Lola Export] Parsing arc (" + this.name((FigureWithID)arcConnection.startFigure()) + ")--" + string + "-->(" + this.name((FigureWithID)arcConnection.endFigure()) + ")  -- Cardinality is " + n));
        }
        if (bl) {
            n = n2;
        }
        return n;
    }

    private HashMap<String, Integer> postset(Drawing drawing, TransitionFigure transitionFigure) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            String string;
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof ArcConnection)) continue;
            ArcConnection arcConnection = (ArcConnection)figure;
            Integer n = arcConnection.getArcType();
            Figure figure2 = arcConnection.endFigure();
            Figure figure3 = arcConnection.startFigure();
            if (figure3.equals(transitionFigure) && figure2 instanceof PlaceFigure) {
                string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure2));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, this.parseArcInscription(arcConnection));
                    continue;
                }
                hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
                continue;
            }
            if (!figure2.equals(transitionFigure) || n != 0 && n != 2 || !(figure3 instanceof PlaceFigure)) continue;
            string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure3));
            if (hashMap.get(string) == null) {
                hashMap.put(string, this.parseArcInscription(arcConnection));
                continue;
            }
            hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola Export] Postset of " + this.name((FigureWithID)transitionFigure) + " is: " + hashMap.toString()));
        }
        return hashMap;
    }

    public String name(FigureWithID figureWithID) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = false;
        if (figureWithID instanceof PlaceFigure || figureWithID instanceof TransitionFigure) {
            int n = figureWithID.getID();
            if (this.usedFigureNames.containsKey(figureWithID)) {
                stringBuffer.append(this.usedFigureNames.get(figureWithID));
                bl = true;
            } else {
                FigureEnumeration figureEnumeration = ((AttributeFigure)figureWithID).children();
                while (figureEnumeration.hasMoreElements() && !bl.booleanValue()) {
                    Figure figure = (Figure)figureEnumeration.nextElement();
                    if (!(figure instanceof CPNTextFigure) || ((CPNTextFigure)figure).getType() != 2) continue;
                    Object object = ((CPNTextFigure)figure).getText();
                    String string = "^\\p{Alpha}[\\p{Alnum}_-]*[0-9]*\\b";
                    String[] stringArray = new String[]{"IF", "RECORD", "END", "SORT", "FUNCTION", "SAFE", "DO", "ARRAY", "STRONG", "WEAK", "FAIR", "ENUMERATE", "CONSTANT", "BOOLEAN", "OF", "BEGIN", "WHILE", "IF", "THEN", "ELSE", "SWITCH", "CASE", "NEXTSTEP", "REPEAT", "FOR", "TO", "ALL", "EXIT", "EXISTS", "RETURN", "TRUE", "FALSE", "MOD", "VAR", "GUARD", "STATE", "PATH", "GENERATOR", "ANALYSE", "PLACE", "TRANSITION", "MARKING", "CONSUME", "PRODUCE", "FORMULA", "EXPATH", "ALLPATH", "ALWAYS", "UNTIL", "EVENTUALLY", "AND", "OR", "NOT"};
                    Boolean bl2 = true;
                    for (String string2 : stringArray) {
                        if (!((String)object).equals(string2)) continue;
                        bl2 = false;
                        break;
                    }
                    if (((String)object).matches(string) && bl2.booleanValue()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("[Lola Export] Name of figure seems to be okay: " + (String)object));
                        }
                        if (this.usedFigureNames.containsValue(object) && this.usedFigureNames.containsKey(object = (String)object + n)) {
                            logger.error((Object)("Exception: Name " + (String)object + " already exists"));
                        }
                        stringBuffer.append((String)object);
                        this.usedFigureNames.put((Figure)figureWithID, (String)object);
                        bl = true;
                        continue;
                    }
                    logger.error((Object)("[Lola Export] Name " + (String)object + " is not valid syntactically."));
                }
            }
            if (!bl.booleanValue()) {
                stringBuffer.append(figureWithID instanceof PlaceFigure ? "p" : "t");
                stringBuffer.append(n);
                if (this.usedFigureNames.containsValue("p" + n) || this.usedFigureNames.containsValue("t" + n)) {
                    stringBuffer.append("Exception42");
                }
            }
        }
        return stringBuffer.toString();
    }

    public StringBuffer constructStatePredicate(TransitionFigure transitionFigure, Drawing drawing) {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, Integer> hashMap = this.preset(drawing, transitionFigure);
        Iterator<String> iterator = hashMap.keySet().iterator();
        int n = hashMap.size();
        int n2 = n - 2;
        while (iterator.hasNext()) {
            String string = iterator.next();
            --n;
            stringBuffer.append(string);
            stringBuffer.append(" >= ");
            stringBuffer.append(hashMap.get(string));
            if (n >= 1) {
                stringBuffer.append(" AND ");
            }
            if (n < 2) continue;
            stringBuffer.append("(");
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(")");
        }
        return stringBuffer;
    }

    public HashMap<String, String> getInitialMarking(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = this.extractMarking(cPNDrawing);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = stringBuffer.substring(8).trim();
        string = string.substring(0, string.length() - 1);
        while (!string.equals("")) {
            String string2 = string.substring(string.lastIndexOf(",") + 1, string.length()).trim();
            String string3 = string2.substring(0, string2.lastIndexOf(":"));
            String string4 = string2.substring(string2.lastIndexOf(":") + 2);
            hashMap.put(string3, string4);
            if (string.lastIndexOf(",") >= 0) {
                string = string.substring(0, string.lastIndexOf(","));
                continue;
            }
            string = "";
        }
        return hashMap;
    }

    public Vector<LolaTask> parseTasks(CPNDrawing cPNDrawing) {
        Vector<LolaTask> vector = new Vector<LolaTask>();
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            LolaTask lolaTask;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof TextFigure) || !(lolaTask = new LolaTask((TextFigure)figure, cPNDrawing)).isValid()) continue;
            vector.add(lolaTask);
        }
        return vector;
    }
}

