#!/bin/bash
for program in graph2dot lola lola-bounded-net lola-bounded-place lola-dead-transition lola-deadlock lola-home-state lola-liveprop lola-model-checking lola-reach-mark lola-reversible lola-state-predicate; do
  echo "Trying to run ${program}. Mac OS will probably tell you that ${program} cannot be opened because the developer cannot be verified and propose to move it to trash. Please click \"Cancel\" and allow the app to run in the Security & Privacy Settings (see https://support.apple.com/en-us/HT202491 for details)."
  ./${program} --help > /dev/null 2> /dev/null
  read -p "Press return after you allowed the application to run. You may need to click one more time on \"Open\" for ${program}."
  ./${program} --help > /dev/null 2> /dev/null
  if [ $? = 0 ]; then
    echo "Successfully ran ${program}."
  else 
    echo "${program} did not run correct. You may need to repeat the process (or there is some other problem)"
  fi
  echo
done