/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola.parser;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingHelper;
import de.renew.gui.PlaceFigure;
import de.renew.lola.parser.Marking;
import de.renew.lola.parser.NetFileParseError;
import de.renew.lola.parser.Node;
import de.renew.lola.parser.Place;
import de.renew.lola.parser.Transition;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class LolaParser {
    private static Logger logger = Logger.getLogger(LolaParser.class);
    private List<Transition> transitions = new ArrayList<Transition>();
    private List<Place> places = new ArrayList<Place>();
    private Map<String, Node> elementsMap = new HashMap<String, Node>();
    private Map<Node, AttributeFigure> figureMap = new HashMap<Node, AttributeFigure>();
    private final int ORDINARY_ARC = 1;

    public void parse(InputStream inputStream) throws NetFileParseError {
        logger.info((Object)"[Lola] Lola Import: Starting parser.");
        Scanner scanner = new Scanner(new BufferedReader(new InputStreamReader(inputStream)));
        scanner.useDelimiter(";");
        scanner.findWithinHorizon("PLACE", 0);
        this.places = LolaParser.parsePlaces(scanner.next());
        for (Place object : this.places) {
            this.elementsMap.put(object.getName(), object);
        }
        scanner.findWithinHorizon("MARKING", 0);
        Map<Place, Integer> map = this.parseMarking(scanner.next());
        for (Place place : map.keySet()) {
            place.setInitialMarking((Integer)map.get(place));
        }
        scanner.useDelimiter(";?\\s*TRANSITION");
        while (scanner.hasNext()) {
            Transition transition = this.parseTransition(scanner.next());
            this.transitions.add(transition);
            this.elementsMap.put(transition.getName(), transition);
        }
    }

    public Transition parseTransition(String string) throws NetFileParseError {
        Object object;
        if (string.trim().endsWith(";")) {
            string = string.substring(0, string.trim().length());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Now parsing the transition\n" + string));
        }
        Scanner scanner = new Scanner(string);
        String string2 = scanner.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string2);
        }
        String[] stringArray = string2.split("\\{");
        String string3 = stringArray[0].trim();
        Transition transition = new Transition(string3);
        if (string2.contains("{") && stringArray.length > 1 && (object = LolaParser.parseCoordinates(stringArray[1].trim())) != null) {
            transition.setX(object[0]);
            transition.setY(object[1]);
        }
        if (scanner.next().equals("CONSUME")) {
            scanner.useDelimiter(";\\s*PRODUCE");
            object = scanner.next();
            if (object != null) {
                Map<Place, Integer> map = this.parseMarking((String)object);
                transition.setPre(map);
            }
        } else {
            throw new NetFileParseError("Missing CONSUME keyword");
        }
        if (!scanner.hasNext()) {
            throw new NetFileParseError("Missing PRODUCE keyword");
        }
        object = this.parseMarking(scanner.next());
        transition.setPost((Map<Place, Integer>)object);
        return transition;
    }

    public Map<Place, Integer> parseMarking(String string) throws NetFileParseError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Now parse the marking");
        }
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter(",");
        HashMap<Place, Integer> hashMap = new HashMap<Place, Integer>();
        while (scanner.hasNext()) {
            try {
                Marking marking = LolaParser.parseToken(scanner.next());
                if (marking == null) continue;
                Place place = (Place)this.forName(marking.getName());
                hashMap.put(place, marking.getTokens());
            }
            catch (NetFileParseError netFileParseError) {
                netFileParseError.printStackTrace();
                throw netFileParseError;
            }
        }
        return hashMap;
    }

    public Node forName(String string) {
        return this.elementsMap.get(string);
    }

    public static Marking parseToken(String string) throws NetFileParseError {
        if (string != null && !string.trim().isEmpty()) {
            String[] stringArray = string.split(":");
            if (stringArray.length > 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(stringArray[0] + " has " + stringArray[1] + " tokens."));
                }
                try {
                    Integer n = Integer.parseInt(stringArray[1].trim());
                    Marking marking = new Marking(stringArray[0].trim(), n);
                    return marking;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NetFileParseError("Could not parse token number");
                }
            }
            throw new NetFileParseError("Place without marking not allowed in MARKING section");
        }
        return null;
    }

    public static List<Place> parsePlaces(String string) throws NetFileParseError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"First parse the places");
        }
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter(",");
        ArrayList<Place> arrayList = new ArrayList<Place>();
        while (scanner.hasNext()) {
            arrayList.add(LolaParser.parsePlace(scanner.next()));
        }
        return arrayList;
    }

    public static Place parsePlace(String string) throws NetFileParseError {
        int[] nArray;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string);
        }
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter("\\{");
        String string2 = scanner.next().trim();
        Place place = new Place(string2);
        if (scanner.hasNext() && (nArray = LolaParser.parseCoordinates(scanner.next())) != null) {
            place.setX(nArray[0]);
            place.setY(nArray[1]);
        }
        return place;
    }

    private static int[] parseCoordinates(String string) throws NetFileParseError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string);
        }
        if (string.startsWith("x") && string.contains("y")) {
            int[] nArray = new int[2];
            try {
                String string2 = string.substring(string.indexOf(":") + 1, string.indexOf("y"));
                String string3 = string.substring(string.lastIndexOf(":") + 1, string.indexOf("}"));
                nArray[0] = Integer.parseInt(string2);
                nArray[1] = Integer.parseInt(string3);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Coordinates: (x=" + string2 + "|y=" + string3 + ")"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NetFileParseError("Coordinates could not be parsed");
            }
            return nArray;
        }
        throw new NetFileParseError("Comment does not contain coordinates");
    }

    public CPNDrawing importNet(InputStream inputStream) {
        PlaceFigure placeFigure;
        try {
            this.parse(inputStream);
        }
        catch (NetFileParseError netFileParseError) {
            logger.error((Object)("[LolaParser] : " + netFileParseError.getMessage()));
            return new CPNDrawing();
        }
        CPNDrawing cPNDrawing = new CPNDrawing();
        CPNDrawingHelper cPNDrawingHelper = new CPNDrawingHelper();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Drawing places");
        }
        for (Place node : this.places) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Drawing place " + String.valueOf(node) + " (" + node.getX() + "|" + node.getY()));
            }
            placeFigure = cPNDrawingHelper.createPlace();
            if (node.hasCoordinates()) {
                placeFigure.moveBy(node.getX().intValue(), node.getY().intValue());
            }
            cPNDrawing.add((Figure)placeFigure);
            cPNDrawing.add((Figure)cPNDrawingHelper.createNameTextFigure(node.getName(), (ParentFigure)placeFigure));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added and named place " + String.valueOf(node)));
            }
            this.figureMap.put(node, (AttributeFigure)placeFigure);
            if (!node.initiallyMarked()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding marking " + node.getInitialMarking()));
            }
            for (int i = 0; i < node.getInitialMarking(); ++i) {
                cPNDrawing.add((Figure)cPNDrawingHelper.createInscription("[]", (ParentFigure)placeFigure));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Drawing transitions");
        }
        for (Transition transition : this.transitions) {
            int n;
            ArcConnection arcConnection;
            placeFigure = cPNDrawingHelper.createTransition();
            if (transition.hasCoordinates()) {
                placeFigure.moveBy(transition.getX().intValue(), transition.getY().intValue());
            }
            cPNDrawing.add((Figure)placeFigure);
            this.figureMap.put(transition, (AttributeFigure)placeFigure);
            cPNDrawing.add((Figure)cPNDrawingHelper.createNameTextFigure(transition.getName(), (ParentFigure)placeFigure));
            for (Place place : transition.getPre().keySet()) {
                arcConnection = cPNDrawingHelper.createArcConnection(this.figureOf(place), (AttributeFigure)placeFigure, 1);
                cPNDrawing.add((Figure)arcConnection);
                n = transition.getPre().get(place);
                if (n <= 1) continue;
                cPNDrawing.add((Figure)cPNDrawingHelper.createWeightTextFigure(arcConnection, n));
            }
            for (Place place : transition.getPost().keySet()) {
                arcConnection = cPNDrawingHelper.createArcConnection((AttributeFigure)placeFigure, this.figureOf(place), 1);
                cPNDrawing.add((Figure)arcConnection);
                n = transition.getPost().get(place);
                if (n <= 1) continue;
                cPNDrawing.add((Figure)cPNDrawingHelper.createWeightTextFigure(arcConnection, n));
            }
        }
        return cPNDrawing;
    }

    private AttributeFigure figureOf(Node node) {
        return this.figureMap.get(node);
    }
}

