/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyBlobAddFilter
extends CommitDiffFilter {
    public EmptyBlobAddFilter() {
    }

    public EmptyBlobAddFilter(boolean detectRenames) {
        super(detectRenames);
    }

    @Override
    public boolean include(RevCommit commit, Collection<DiffEntry> diffs) throws IOException {
        for (DiffEntry diff : diffs) {
            AbbreviatedObjectId oldId = diff.getOldId();
            if (oldId == null || Constants.EMPTY_BLOB_ID.equals((AnyObjectId)oldId.toObjectId()) || !Constants.EMPTY_BLOB_ID.equals((AnyObjectId)diff.getNewId().toObjectId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public RevFilter clone() {
        return new EmptyBlobAddFilter(this.detectRenames);
    }
}

