/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.gitective.core.Assert;
import org.gitective.core.CommitUtils;
import org.gitective.core.GitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlobUtils {
    protected static byte[] getBytes(Repository repository, ObjectId id) {
        try {
            return repository.open((AnyObjectId)id, 3).getCachedBytes(Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
    }

    protected static byte[] getBytes(ObjectReader reader, ObjectId id) {
        try {
            return reader.open((AnyObjectId)id, 3).getCachedBytes(Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new GitException(e, null);
        }
    }

    protected static String toString(Repository repository, byte[] raw) {
        if (raw == null) {
            return null;
        }
        try {
            return new String(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GitException(e, repository);
        }
    }

    public static String getContent(Repository repository, ObjectId id) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (id == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Object id"));
        }
        return BlobUtils.toString(repository, BlobUtils.getBytes(repository, id));
    }

    protected static ObjectId lookupId(Repository repository, RevCommit commit, String path) {
        TreeWalk walk;
        try {
            walk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)commit.getTree());
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        if (walk == null) {
            return null;
        }
        if ((walk.getRawMode(0) & 0xF000) != 32768) {
            return null;
        }
        return walk.getObjectId(0);
    }

    protected static byte[] getBytes(Repository repository, RevCommit commit, String path) {
        ObjectId id = BlobUtils.lookupId(repository, commit, path);
        return id != null ? BlobUtils.getBytes(repository, id) : null;
    }

    public static byte[] getRawContent(Repository repository, String revision, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, CommitUtils.strictResolve(repository, revision));
        return BlobUtils.getBytes(repository, commit, path);
    }

    public static byte[] getRawContent(Repository repository, ObjectId commitId, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commitId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit id"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, commitId);
        return BlobUtils.getBytes(repository, commit, path);
    }

    public static String getContent(Repository repository, ObjectId commitId, String path) {
        return BlobUtils.toString(repository, BlobUtils.getRawContent(repository, commitId, path));
    }

    public static String getContent(Repository repository, String revision, String path) {
        return BlobUtils.toString(repository, BlobUtils.getRawContent(repository, revision, path));
    }

    public static String getHeadContent(Repository repository, String path) {
        return BlobUtils.getContent(repository, "HEAD", path);
    }

    public static byte[] getRawHeadContent(Repository repository, String path) {
        return BlobUtils.getRawContent(repository, "HEAD", path);
    }

    public static ObjectId getId(Repository repository, String revision, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, CommitUtils.strictResolve(repository, revision));
        return BlobUtils.lookupId(repository, commit, path);
    }

    public static ObjectId getHeadId(Repository repository, String path) {
        return BlobUtils.getId(repository, "HEAD", path);
    }

    public static ObjectId getId(Repository repository, ObjectId commitId, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commitId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit id"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, commitId);
        return BlobUtils.lookupId(repository, commit, path);
    }

    public static ObjectStream getStream(Repository repository, ObjectId commitId, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commitId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit id"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, commitId);
        ObjectId blobId = BlobUtils.lookupId(repository, commit, path);
        if (blobId == null) {
            return null;
        }
        try {
            return repository.open((AnyObjectId)blobId, 3).openStream();
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
    }

    public static ObjectStream getHeadStream(Repository repository, String path) {
        return BlobUtils.getStream(repository, "HEAD", path);
    }

    public static ObjectStream getStream(Repository repository, String revision, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevCommit commit = CommitUtils.parse(repository, CommitUtils.strictResolve(repository, revision));
        ObjectId blobId = BlobUtils.lookupId(repository, commit, path);
        if (blobId == null) {
            return null;
        }
        try {
            return repository.open((AnyObjectId)blobId, 3).openStream();
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
    }

    public static Collection<Edit> diff(Repository repository, ObjectId blob1, ObjectId blob2) {
        return BlobUtils.diff(repository, blob1, blob2, RawTextComparator.DEFAULT);
    }

    public static Collection<Edit> diff(Repository repository, ObjectId blob1, ObjectId blob2, RawTextComparator comparator) {
        byte[] data2;
        byte[] data1;
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (blob1 == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Blob id 1"));
        }
        if (blob2 == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Blob id 2"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Comparator"));
        }
        if (blob1.equals((AnyObjectId)blob2)) {
            return Collections.emptyList();
        }
        if (!blob1.equals((AnyObjectId)ObjectId.zeroId())) {
            data1 = BlobUtils.getBytes(repository, blob1);
            if (RawText.isBinary((byte[])data1)) {
                return Collections.emptyList();
            }
        } else {
            data1 = new byte[]{};
        }
        if (!blob2.equals((AnyObjectId)ObjectId.zeroId())) {
            data2 = BlobUtils.getBytes(repository, blob2);
            if (RawText.isBinary((byte[])data2)) {
                return Collections.emptyList();
            }
        } else {
            data2 = new byte[]{};
        }
        return new HistogramDiff().diff((SequenceComparator)comparator, (Sequence)(data1.length > 0 ? new RawText(data1) : RawText.EMPTY_TEXT), (Sequence)(data2.length > 0 ? new RawText(data2) : RawText.EMPTY_TEXT));
    }

    public static Collection<Edit> diff(ObjectReader reader, ObjectId blob1, ObjectId blob2) {
        return BlobUtils.diff(reader, blob1, blob2, RawTextComparator.DEFAULT);
    }

    public static Collection<Edit> diff(ObjectReader reader, ObjectId blob1, ObjectId blob2, RawTextComparator comparator) {
        byte[] data2;
        byte[] data1;
        if (reader == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Reader"));
        }
        if (blob1 == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Blob id 1"));
        }
        if (blob2 == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Blob id 2"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Comparator"));
        }
        if (blob1.equals((AnyObjectId)blob2)) {
            return Collections.emptyList();
        }
        if (!blob1.equals((AnyObjectId)ObjectId.zeroId())) {
            data1 = BlobUtils.getBytes(reader, blob1);
            if (RawText.isBinary((byte[])data1)) {
                return Collections.emptyList();
            }
        } else {
            data1 = new byte[]{};
        }
        if (!blob2.equals((AnyObjectId)ObjectId.zeroId())) {
            data2 = BlobUtils.getBytes(reader, blob2);
            if (RawText.isBinary((byte[])data2)) {
                return Collections.emptyList();
            }
        } else {
            data2 = new byte[]{};
        }
        return new HistogramDiff().diff((SequenceComparator)comparator, (Sequence)(data1.length > 0 ? new RawText(data1) : RawText.EMPTY_TEXT), (Sequence)(data2.length > 0 ? new RawText(data2) : RawText.EMPTY_TEXT));
    }
}

