/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.Animatable;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class Animator
implements Runnable {
    private static Logger logger = Logger.getLogger(Animator.class);
    private static final int MAX_DELAY = 62;
    private static final int MIN_DELAY = 15;
    private DrawingView fView;
    private Animatable fAnimatable;
    private boolean fIsRunning;

    public Animator(Animatable animatable, DrawingView drawingView) {
        this.fView = drawingView;
        this.fAnimatable = animatable;
    }

    public void end() {
        this.fAnimatable.animationStop();
        this.fIsRunning = false;
    }

    @Override
    public void run() {
        this.fIsRunning = true;
        this.fAnimatable.animationStart();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Animator.this.fAnimatable.animationStep();
                Animator.this.fView.checkDamage();
            }
        };
        while (this.fIsRunning) {
            block6: {
                long l = System.currentTimeMillis();
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.warn((Object)invocationTargetException.getMessage());
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)(Animator.class.getSimpleName() + ": " + String.valueOf(invocationTargetException)));
                }
            }
            try {
                Thread.sleep(Math.max(15L, (l += 62L) - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }
}

