/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.RelativeLocator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class SouthEastHandle
extends LocatorHandle {
    private float ratio = 1.0f;

    SouthEastHandle(Figure figure) {
        super(figure, RelativeLocator.southEast());
        if (figure.displayBox().width != 0) {
            this.ratio = (float)figure.displayBox().height / (float)figure.displayBox().width;
        }
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        Rectangle rectangle = this.owner().displayBox();
        int n5 = Math.max(rectangle.x, n);
        int n6 = Math.max(rectangle.y, n2);
        if (mouseEvent.isControlDown() && this.ratio != 0.0f) {
            this.owner().displayBox(new Point(rectangle.x, rectangle.y), new Point(n5, n5 - this.owner().displayBox().x + this.owner().displayBox().y));
        } else if (mouseEvent.isShiftDown()) {
            this.owner().displayBox(new Point(rectangle.x, rectangle.y), new Point(n5, Math.max(rectangle.y, Math.round((float)(n - rectangle.x) * this.ratio + (float)rectangle.y))));
        } else {
            this.owner().displayBox(new Point(rectangle.x, rectangle.y), new Point(n5, n6));
        }
    }
}

