/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.standard.UndoableTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends UndoableTool {
    private Point fAnchorPoint;
    private Figure fCreatedFigure;
    private Figure fPrototype;

    public CreationTool(DrawingEditor drawingEditor, Figure figure) {
        super(drawingEditor);
        this.fPrototype = figure;
    }

    protected CreationTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.fPrototype = null;
    }

    protected Figure getPrototype() {
        return this.fPrototype;
    }

    @Override
    public void activate() {
        super.activate();
        this.view().setCursor(Cursor.getPredefinedCursor(1));
        this.fAnchorPoint = null;
        this.fCreatedFigure = null;
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.fCreatedFigure = this.createFigure();
        this.fAnchorPoint = mouseEvent.isControlDown() ? new Point(n, n - this.fCreatedFigure.displayBox().x + this.fCreatedFigure.displayBox().y) : new Point(n, n2);
        this.fCreatedFigure.displayBox(this.fAnchorPoint, this.fAnchorPoint);
        this.view().add(this.fCreatedFigure);
        this.changesMade();
    }

    protected Figure createFigure() {
        if (this.fPrototype == null) {
            throw new HJDError("No prototype defined");
        }
        return (Figure)this.fPrototype.clone();
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.isControlDown()) {
            this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(n, n - this.fCreatedFigure.displayBox().x + this.fCreatedFigure.displayBox().y));
        } else {
            this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(n, n2));
        }
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.fCreatedFigure.isEmpty()) {
            this.drawing().remove(this.fCreatedFigure);
            this.noChangesMade();
        }
        this.fCreatedFigure = null;
        this.editor().toolDone();
    }

    protected Figure createdFigure() {
        return this.fCreatedFigure;
    }
}

