/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.UndoableTool;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionTool
extends UndoableTool {
    private Connector fStartConnector;
    private Connector fEndConnector;
    private Connector fConnectorTarget = null;
    private Figure fTarget = null;
    private ConnectionFigure fConnection = null;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection = null;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingEditor drawingEditor, ConnectionFigure connectionFigure) {
        super(drawingEditor);
        this.fPrototype = connectionFigure;
    }

    @Override
    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        this.trackConnectors(mouseEvent, n, n2);
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        ConnectionFigure connectionFigure = this.findConnection(n, n2, this.drawing());
        if (connectionFigure != null) {
            if (!connectionFigure.joinSegments(n, n2)) {
                this.fSplitPoint = connectionFigure.splitSegment(n, n2);
                this.fEditedConnection = connectionFigure;
            } else {
                this.fEditedConnection = null;
            }
            this.changesMade();
        } else {
            this.fConnection = this.createConnection();
            this.fTarget = this.findConnectionStart(n, n2, this.drawing());
            if (this.fTarget != null) {
                this.fStartConnector = this.findConnector(n, n2, this.fTarget);
                if (this.fStartConnector != null) {
                    Point point = new Point(n, n2);
                    this.fConnection.startPoint(point.x, point.y);
                    this.fConnection.endPoint(point.x, point.y);
                    this.view().add(this.fConnection);
                    this.changesMade();
                } else {
                    this.fConnection = null;
                }
            } else {
                this.fConnection = null;
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        Point point = new Point(n, n2);
        if (this.fConnection != null) {
            this.trackConnectors(mouseEvent, n, n2);
            if (this.fConnectorTarget != null) {
                point = Geom.center(this.fConnectorTarget.displayBox());
            }
            this.fConnection.endPoint(point.x, point.y);
        } else if (this.fEditedConnection != null) {
            Point point2 = new Point(n, n2);
            this.fEditedConnection.setPointAt(point2, this.fSplitPoint);
        }
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = null;
        if (this.fStartConnector != null) {
            figure = this.findTarget(n, n2, this.drawing());
        }
        if (figure != null) {
            this.fEndConnector = this.findConnector(n, n2, figure);
            if (this.fEndConnector != null) {
                this.fConnection.connectStart(this.fStartConnector);
                this.fConnection.connectEnd(this.fEndConnector);
                this.fConnection.updateConnection();
            }
        } else if (this.fConnection != null) {
            this.view().remove(this.fConnection);
            this.noChangesMade();
        }
        this.fConnection = null;
        this.fEndConnector = null;
        this.fStartConnector = null;
        this.editor().toolDone();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.fConnection != null) {
            this.view().remove(this.fConnection);
            this.noChangesMade();
            this.fConnection = null;
            this.fEndConnector = null;
            this.fStartConnector = null;
        }
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int n, int n2, Drawing drawing) {
        List<Figure> list = this.findAllConnectableFigures(n, n2, drawing);
        for (Figure figure : list) {
            if (figure == null || this.fConnection == null || !figure.canConnect() || !this.fConnection.canConnectStart(figure)) continue;
            return figure;
        }
        return null;
    }

    protected Figure findTarget(int n, int n2, Drawing drawing) {
        List<Figure> list = this.findAllConnectableFigures(n, n2, drawing);
        Figure figure = this.fStartConnector.owner();
        for (Figure figure2 : list) {
            if (figure2 == null || this.fConnection == null || !figure2.canConnect() || figure2.includes(figure) || !this.fConnection.canConnect(figure, figure2)) continue;
            return figure2;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if ((figure = figure.findFigureInside(n, n2)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected ConnectionFigure createdFigure() {
        return this.fConnection;
    }

    protected void trackConnectors(MouseEvent mouseEvent, int n, int n2) {
        if (this.fConnection == null) {
            return;
        }
        Figure figure = null;
        figure = this.fStartConnector == null ? this.findSource(n, n2, this.drawing()) : this.findTarget(n, n2, this.drawing());
        if (figure != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = figure;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        Connector connector = null;
        if (figure != null) {
            connector = this.findConnector(n, n2, figure);
        }
        if (connector != this.fConnectorTarget) {
            this.fConnectorTarget = connector;
        }
        this.view().checkDamage();
    }

    private Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    protected Figure findConnectionStart(int n, int n2, Drawing drawing) {
        List<Figure> list = this.findAllConnectableFigures(n, n2, drawing);
        for (Figure figure : list) {
            if (figure == null || !figure.canConnect() || !this.fConnection.canConnectStart(figure)) continue;
            return figure;
        }
        return null;
    }

    private List<Figure> findAllConnectableFigures(int n, int n2, Drawing drawing) {
        ArrayList<Figure> arrayList = new ArrayList<Figure>();
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (this.fConnection != null && figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    protected Connector getStartConnector() {
        return this.fStartConnector;
    }

    protected Connector getEndConnector() {
        return this.fEndConnector;
    }

    protected Connector getTarget() {
        return this.fConnectorTarget;
    }
}

