/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class AbstractHandle
implements Handle {
    public static final int HANDLESIZE = 8;
    private Figure fOwner;
    private boolean didChange;

    public AbstractHandle(Figure figure) {
        this.fOwner = figure;
        this.noChangesMade();
    }

    @Override
    public abstract Point locate();

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        drawingView.editor().prepareUndoSnapshot();
        this.changesMade();
    }

    @Override
    public void invokeStart(MouseEvent mouseEvent, int n, int n2, DrawingView drawingView) {
        this.invokeStart(n, n2, drawingView);
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.invokeStep(n, n2, n3, n4, drawingView);
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        if (this.didChange) {
            drawingView.editor().commitUndoSnapshot();
        }
        this.noChangesMade();
    }

    @Override
    public void invokeEnd(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.invokeEnd(n, n2, n3, n4, drawingView);
    }

    protected void noChangesMade() {
        this.didChange = false;
    }

    protected void changesMade() {
        this.didChange = true;
    }

    @Override
    public Figure owner() {
        return this.fOwner;
    }

    @Override
    public Rectangle displayBox() {
        Point point = this.locate();
        return new Rectangle(point.x - 4, point.y - 4, 8, 8);
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

