/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    private static final long serialVersionUID = 6883731614578414801L;
    protected Connector fStart = null;
    protected Connector fEnd = null;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration();
        this.setEndDecoration();
    }

    public LineConnection(LineDecoration lineDecoration, LineDecoration lineDecoration2, String string) {
        super(2);
        this.setStartDecoration(lineDecoration);
        this.setEndDecoration(lineDecoration2);
        this.setLineStyle(string);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        ((Point)this.fPoints.firstElement()).translate(-n, -n2);
        ((Point)this.fPoints.lastElement()).translate(-n, -n2);
        super.basicMoveBy(n, n2);
        this.updateConnection();
    }

    @Override
    public void connectStart(Connector connector) {
        this.fStart = connector;
        this.startFigure().addFigureChangeListener(this);
        if (this.fStart != null && this.fEnd != null) {
            this.handleConnect(this.startFigure(), this.endFigure());
        }
        if (guilogger.isTraceEnabled()) {
            guilogger.trace((Object)("LineConnection: set start of " + String.valueOf(this) + " to " + String.valueOf(this.startFigure())));
        }
    }

    @Override
    public void connectEnd(Connector connector) {
        this.fEnd = connector;
        this.endFigure().addFigureChangeListener(this);
        this.handleConnect(this.startFigure(), this.endFigure());
        if (guilogger.isTraceEnabled()) {
            guilogger.trace((Object)("LineConnection: set end of " + String.valueOf(this) + " to " + String.valueOf(this.endFigure())));
        }
    }

    @Override
    public void disconnectStart() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.startFigure().removeFigureChangeListener(this);
        this.fStart = null;
    }

    @Override
    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.fEnd = null;
    }

    @Override
    public boolean connectsSame(ConnectionFigure connectionFigure) {
        return connectionFigure.start() == this.start() && connectionFigure.end() == this.end();
    }

    protected void handleDisconnect(Figure figure, Figure figure2) {
    }

    protected void handleConnect(Figure figure, Figure figure2) {
    }

    public Figure startFigure() {
        if (this.start() != null) {
            return this.start().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.end() != null) {
            return this.end().owner();
        }
        return null;
    }

    @Override
    public Connector start() {
        return this.fStart;
    }

    @Override
    public Connector end() {
        return this.fEnd;
    }

    @Override
    public boolean canConnect(Figure figure, Figure figure2) {
        return true;
    }

    @Override
    public void startPoint(int n, int n2) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            super.addPoint(n, n2);
        } else {
            super.setPointAt(new Point(n, n2), 0);
        }
    }

    @Override
    public void startPoint(Point point) {
        this.startPoint(point.x, point.y);
    }

    @Override
    public void endPoint(int n, int n2) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            super.addPoint(n, n2);
        } else {
            super.setPointAt(new Point(n, n2), this.fPoints.size() - 1);
        }
    }

    @Override
    public void endPoint(Point point) {
        this.endPoint(point.x, point.y);
    }

    @Override
    public Point startPoint() {
        Point point = (Point)this.fPoints.firstElement();
        return new Point(point.x, point.y);
    }

    @Override
    public Point endPoint() {
        Point point = (Point)this.fPoints.lastElement();
        return new Point(point.x, point.y);
    }

    @Override
    public Vector<Handle> handles() {
        int n = this.fPoints.size();
        Vector<Handle> vector = new Vector<Handle>(2 * n);
        vector.addElement(new ChangeConnectionStartHandle(this));
        this.addIntermediateHandles(vector);
        vector.addElement(new ChangeConnectionEndHandle(this));
        return vector;
    }

    @Override
    public void setPointAt(Point point, int n) {
        super.setPointAt(point, n);
        this.layoutConnection();
    }

    @Override
    public void insertPointAt(Point point, int n) {
        super.insertPointAt(point, n);
        this.layoutConnection();
    }

    @Override
    public void removePointAt(int n) {
        super.removePointAt(n);
        this.layoutConnection();
    }

    @Override
    public void updateConnection() {
        Point point;
        if (this.fStart != null) {
            point = this.fStart.findStart(this);
            this.startPoint(point.x, point.y);
        }
        if (this.fEnd != null) {
            point = this.fEnd.findEnd(this);
            this.endPoint(point.x, point.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    @Override
    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateConnection();
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.fStart != null) {
            this.startFigure().removeFigureChangeListener(this);
        }
        if (this.fEnd != null) {
            this.endFigure().removeFigureChangeListener(this);
        }
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration figureEnumeration = super.getFiguresWithDependencies();
        Vector<Figure> vector = new Vector<Figure>(2);
        vector.addElement(this.start().owner());
        vector.addElement(this.end().owner());
        return new MergedFigureEnumerator(figureEnumeration, new FigureEnumerator(vector));
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.fStart);
        storableOutput.writeStorable(this.fEnd);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        Connector connector;
        super.read(storableInput);
        Connector connector2 = (Connector)storableInput.readStorable();
        if (connector2 != null) {
            this.connectStart(connector2);
        }
        if ((connector = (Connector)storableInput.readStorable()) != null) {
            this.connectEnd(connector);
        }
        if (connector2 != null && connector != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.fStart != null) {
            this.connectStart(this.fStart);
        }
        if (this.fEnd != null) {
            this.connectEnd(this.fEnd);
        }
    }
}

