/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.FileMenuCreator;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.NoGuiAvailableException;
import CH.ifa.draw.application.OpenDrawingCommand;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.ImportHolderImpl;
import CH.ifa.draw.standard.AlignmentMenuCreator;
import CH.ifa.draw.standard.AttributesMenuCreator;
import CH.ifa.draw.standard.EditMenuCreator;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.GUIProperties;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Provides;
import de.renew.util.StringUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class DrawPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(DrawPlugin.class);
    private static DrawApplication _gui;
    private ImportHolderImpl importHolder;
    private ExportHolderImpl exportHolder;
    public static final String RECENTLY_SAVED = "recently-saved.prop";
    private static final String NUM_RECENT_FILES_KEY = "ch.ifa.draw.num-of-recent-files";
    private ArrayList<String> recentFiles = null;
    private CommandMenu recentlySavedMenu = null;
    private long recentFilesModificationDate = 0L;
    public static final String WINDOW_FOCUS_WORKAROUND_KEY = "ch.ifa.draw.window-focus-workaround";
    private static final String SHOW_RECENTLY_SAVED_HOTKEYS_KEY = "ch.ifa.draw.show-recentlysaved-hotkeys";
    public static final String CH_IFA_DRAW_GRID_SIZE = "ch.ifa.draw.grid.size";
    public static final String CH_IFA_DRAW_GRID_DEFAULT = "ch.ifa.draw.grid.default";
    public static String PLUGINS_MENU;
    public static String PLATFORMS_MENU;
    public static final String FILE_MENU = "File";
    public static final String EDIT_MENU = "Edit";
    public static final String ATTRIBUTES_MENU = "Attributes";
    public static final String LAYOUT_MENU = "Layout";
    public static final String WINDOWS_MENU = "Windows";
    public static final String TOOLS_MENU = "Tools";
    public static final String PAOSE_MENU = "Paose";
    public static final String WINDOWS_CATEGORY_TOOLS = "Tools";
    public static final String HELP_MENU = "Help";
    public static final String MENU_PREFIX = "CH.ifa.draw";
    public static final int[] keys;

    public static void setGui(DrawApplication drawApplication) {
        logger.debug((Object)("IfaPlugin setting gui to " + String.valueOf(drawApplication)));
        _gui = drawApplication;
    }

    @Provides
    public static DrawApplication getGui() {
        return _gui;
    }

    public DrawPlugin(URL uRL) throws PluginException {
        super(uRL);
        DrawPlugin.checkSwing();
    }

    public DrawPlugin(PluginProperties pluginProperties) throws PluginException {
        super(pluginProperties);
        try {
            String string;
            String string2 = PluginProperties.getUserProperties().getProperty("CH.ifa.draw.menutext.plugin");
            if (string2 != null) {
                PLUGINS_MENU = string2;
            }
            if ((string = PluginProperties.getUserProperties().getProperty("CH.ifa.draw.menutext.platforms")) != null) {
                PLATFORMS_MENU = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DrawPlugin.checkSwing();
    }

    private static void checkSwing() throws PluginException {
        try {
            Toolkit.getDefaultToolkit();
            logger.debug((Object)"DrawPlugin: Swing initialization successful.");
        }
        catch (Throwable throwable) {
            logger.debug((Object)("DrawPlugin: Swing initialization failed: " + String.valueOf(throwable)));
            throw new PluginException("Could not initialize Swing, disabling DrawPlugin.", throwable);
        }
    }

    public void init() {
        GUIProperties.setProperties((Properties)this._properties);
        this.importHolder = new ImportHolderImpl();
        this.exportHolder = new ExportHolderImpl();
        this.setRecentlySavedMenu(new CommandMenu("Recently saved"));
        File file = this.readRecentlySavedFileList();
        this.recentFilesModificationDate = file.lastModified();
        this.registerMenuItems(FILE_MENU, new FileMenuCreator().createMenus(this.importHolder, this.exportHolder, this.getRecentlySavedMenu()));
        this.registerMenuItems(EDIT_MENU, new EditMenuCreator().createMenus());
        this.registerMenuItems(LAYOUT_MENU, new AlignmentMenuCreator().createMenus());
        this.registerMenuItems(ATTRIBUTES_MENU, new AttributesMenuCreator().createMenus());
    }

    private File readRecentlySavedFileList() {
        File file = PluginManager.getPreferencesLocation();
        Drawing drawing = null;
        File file2 = new File(file, RECENTLY_SAVED);
        this.recentFiles = new ArrayList();
        if (file2.exists()) {
            drawing = DrawingFileHelper.loadDrawing(file2, null);
            this.putRecentFileNamesInList(drawing);
            this.updateRecentFileMenu();
        } else {
            drawing = new StandardDrawing();
            DrawingFileHelper.saveDrawing(drawing, file2, null);
        }
        return file2;
    }

    public void updateRecentlySavedList(String string) {
        assert (this.recentFiles != null) : "Error: recent file list should not be null.";
        File file = new File(PluginManager.getPreferencesLocation(), RECENTLY_SAVED);
        if (file.lastModified() > this.recentFilesModificationDate) {
            this.readRecentlySavedFileList();
        }
        this.putOneFileNameInListOfRecentFiles(string);
        StandardDrawing standardDrawing = new StandardDrawing();
        int n = 0;
        for (String string2 : this.recentFiles) {
            TextFigure textFigure = new TextFigure(string2);
            standardDrawing.add(textFigure);
            textFigure.moveBy(0, n);
            n += 20;
        }
        DrawingFileHelper.saveDrawing(standardDrawing, file, null);
        this.recentFilesModificationDate = file.lastModified();
        this.updateRecentFileMenu();
    }

    private void putOneFileNameInListOfRecentFiles(String string) {
        if (this.recentFiles.contains(string)) {
            this.recentFiles.remove(string);
        }
        this.recentFiles.add(0, string);
        int n = PluginProperties.getUserProperties().getIntProperty(NUM_RECENT_FILES_KEY, 10);
        if (this.recentFiles.size() > n) {
            this.recentFiles.retainAll(this.recentFiles.subList(0, n));
        }
    }

    private void putRecentFileNamesInList(Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            TextFigure textFigure = (TextFigure)figureEnumeration.nextElement();
            File file = new File(textFigure.getText());
            if (!file.exists()) continue;
            this.recentFiles.add(0, textFigure.getText());
        }
    }

    private void updateRecentFileMenu() {
        Iterator<String> iterator = this.recentFiles.iterator();
        this.getRecentlySavedMenu().removeAll();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawPlugin.class.getName() + ": Putting " + string + " into 'Recently saved' menu."));
            }
            if (!this.getProperties().getBoolProperty(SHOW_RECENTLY_SAVED_HOTKEYS_KEY) || n > 9) {
                this.getRecentlySavedMenu().add(new OpenDrawingCommand(string, StringUtil.getFilename((String)string)));
                continue;
            }
            this.getRecentlySavedMenu().add(new OpenDrawingCommand(string, StringUtil.getFilename((String)string)), keys[n++], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 512);
        }
    }

    private void registerMenuItems(String string, Collection<JMenuItem> collection) {
        Iterator<JMenuItem> iterator = collection.iterator();
        MenuManager menuManager = MenuManager.getInstance();
        while (iterator.hasNext()) {
            JMenuItem jMenuItem = iterator.next();
            if (jMenuItem.getClientProperty("ch.ifa.draw.menu.id") == null) {
                jMenuItem.putClientProperty("ch.ifa.draw.menu.id", "CH.ifa.draw." + string + "." + jMenuItem.getText());
            }
            menuManager.registerMenu(string, jMenuItem);
        }
    }

    @Provides
    public IOHelper getIOHelper() {
        return IOHelper.getInstance();
    }

    @Provides
    public ImportHolder getImportHolder() {
        return this.importHolder;
    }

    @Provides
    public ExportHolder getExportHolder() {
        return this.exportHolder;
    }

    public void newDrawingViewContainer(Drawing drawing) {
        DrawPlugin.getGui().newDrawingViewContainer(drawing);
    }

    public static DrawPlugin getCurrent() {
        for (Object e : PluginManager.getInstance().getPluginsProviding("ch.ifa.draw")) {
            if (!(e instanceof DrawPlugin)) continue;
            return (DrawPlugin)((Object)e);
        }
        return null;
    }

    @Provides
    public MenuManager getMenuManager() {
        return MenuManager.getInstance();
    }

    @Provides
    public DrawingEditor getDrawingEditor() {
        DrawingEditor drawingEditor = null;
        DrawApplication drawApplication = DrawPlugin.getGui();
        drawingEditor = drawApplication == null ? NullDrawingEditor.INSTANCE : drawApplication;
        return drawingEditor;
    }

    public void showStatus(final String string) throws NoGuiAvailableException {
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("DrawPlugin: cannot show status: no gui window.");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication != null) {
                    drawApplication.showStatus(string);
                }
            }
        });
    }

    public boolean isGuiPresent() {
        return _gui != null;
    }

    public void setRecentlySavedMenu(CommandMenu commandMenu) {
        this.recentlySavedMenu = commandMenu;
    }

    public CommandMenu getRecentlySavedMenu() {
        return this.recentlySavedMenu;
    }

    static {
        PLUGINS_MENU = "Plugins";
        PLATFORMS_MENU = null;
        keys = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    }
}

