/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import java.util.Observable;

public class BackgroundTask
extends Observable {
    protected String name;
    protected float current;
    protected Runnable cancelAction;

    public BackgroundTask(String string) {
        this.name = string;
        this.current = -1.0f;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.setChanged();
    }

    public float getCurrent() {
        return this.current;
    }

    public void setCurrent(float f) {
        this.current = f;
        this.setChanged();
    }

    public boolean isIndeterminate() {
        return this.current == -1.0f;
    }

    public boolean isCancelable() {
        return this.cancelAction != null;
    }

    public void setCancelAction(Runnable runnable) {
        this.cancelAction = runnable;
        this.setChanged();
    }

    public void cancel() {
        if (this.cancelAction != null) {
            this.cancelAction.run();
        }
    }

    public void increaseCurrent(float f) {
        this.current += f;
        this.setChanged();
    }
}

