/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.io;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatMultiAbstract;
import de.renew.navigator.io.FileFilterBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;

public class FileFilterBuilderImpl
implements FileFilterBuilder {
    private final IOHelper ioHelper;
    private final ImportHolder importHolder;

    public FileFilterBuilderImpl(IOHelper iOHelper, ImportHolder importHolder) {
        this.ioHelper = iOHelper;
        this.importHolder = importHolder;
    }

    @Override
    public CombinationFileFilter buildFileFilter() {
        ImportFormat[] importFormatArray;
        CombinationFileFilter combinationFileFilter = this.ioHelper.getFileFilter();
        for (ImportFormat importFormat : importFormatArray = this.importHolder.allImportFormats()) {
            FileFilterBuilderImpl.addImportFormat(combinationFileFilter, importFormat);
        }
        combinationFileFilter.addAll(this.getExternalFileTypes());
        combinationFileFilter.allowDirectory(true);
        combinationFileFilter.allowHidden(false);
        return combinationFileFilter;
    }

    @Override
    public boolean isExternallyOpenedFile(File file) {
        CombinationFileFilter combinationFileFilter = new CombinationFileFilter("temp");
        combinationFileFilter.addAll(this.getExternalFileTypes());
        return combinationFileFilter.accept(file);
    }

    private static void addImportFormat(CombinationFileFilter combinationFileFilter, ImportFormat importFormat) {
        if (importFormat instanceof ImportFormatMultiAbstract) {
            ImportFormat[] importFormatArray;
            ImportFormatMultiAbstract importFormatMultiAbstract = (ImportFormatMultiAbstract)importFormat;
            for (ImportFormat importFormat2 : importFormatArray = importFormatMultiAbstract.allImportFormats()) {
                FileFilterBuilderImpl.addImportFormat(combinationFileFilter, importFormat2);
            }
            return;
        }
        if (importFormat.fileFilter() instanceof SimpleFileFilter) {
            combinationFileFilter.add((SimpleFileFilter)importFormat.fileFilter());
            return;
        }
        throw new RuntimeException(String.format("Unsupported import format: %s", importFormat.getClass()));
    }

    private Collection<SimpleFileFilter> getExternalFileTypes() {
        return Arrays.asList(new SimpleFileFilter("kb", "Knowledge Base"), new SimpleFileFilter("java", "Java Sourcecode"), new SimpleFileFilter("jsp", "Java Servlet Pages"), new SimpleFileFilter("xml", "Extensible Markup Language"), new SimpleFileFilter("xmi", "XML Metadata Interchange"), new SimpleFileFilter("md", "Markdown"), new SimpleFileFilter("tex", "LaTeX file"), new SimpleFileFilter("html", "Hypertext"), new SimpleFileFilter("cfg", "Configuration"), new SimpleFileFilter("gif", "Graphics Interchange Format"), new SimpleFileFilter("png", "Portable Network Graphics"), new SimpleFileFilter("jpg", "Joint Photographic Experts Group"), new SimpleFileFilter("jpeg", "Joint Photographic Experts Group"));
    }
}

