/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui.actions;

import CH.ifa.draw.DrawPlugin;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class AddFilesAction
extends NavigatorAction {
    private final FilesystemController filesystemCtrl;

    public AddFilesAction(FilesystemController filesystemController) {
        super("Add Files (Ctrl+Shift+O)", "/de/renew/navigator/images/add.png", KeyStroke.getKeyStroke(79, 3));
        this.filesystemCtrl = filesystemController;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(DrawPlugin.getCurrent().getIOHelper().getCurrentDirectory(null));
        FileFilter fileFilter = this.filesystemCtrl.getFileFilter();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(null);
        if (n != 0) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        this.filesystemCtrl.loadRootDirectories(Arrays.asList(fileArray));
        File file = fileArray[0].getParentFile();
        if (file != null && file.isDirectory()) {
            DrawPlugin.getCurrent().getIOHelper().setLastPath(file);
        }
    }
}

