/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.models.Directory;
import de.renew.navigator.models.TreeElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTreeNode
implements MutableTreeNode {
    protected final Vector<TreeNode> children;
    protected final TreeElement model;
    protected TreeNode parent = null;

    public FileTreeNode(TreeElement treeElement) {
        assert (treeElement != null);
        this.children = new Vector();
        this.model = treeElement;
    }

    public Enumeration<TreeNode> children() {
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.model instanceof Directory;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.children.elementAt(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        mutableTreeNode.setParent(this);
        this.children.add(n, mutableTreeNode);
    }

    public void add(MutableTreeNode mutableTreeNode) {
        mutableTreeNode.setParent(this);
        this.children.add(mutableTreeNode);
    }

    @Override
    public void remove(int n) {
        this.children.remove(n);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this.children.remove(mutableTreeNode);
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null && this.parent instanceof MutableTreeNode) {
            ((MutableTreeNode)this.parent).remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    @Override
    public void setUserObject(Object object) {
    }

    public TreePath getPath() {
        LinkedList<FileTreeNode> linkedList = new LinkedList<FileTreeNode>();
        for (TreeNode treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            linkedList.addFirst((FileTreeNode)treeNode);
        }
        return new TreePath(linkedList.toArray(new TreeNode[linkedList.size()]));
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren() || this.children.isEmpty();
    }

    public File getFile() {
        return this.model.getFile();
    }

    public String toString() {
        return this.model.getName();
    }

    public List<FileTreeNode> getOpenedDirectories() {
        if (!(this.model instanceof Directory)) {
            return Collections.emptyList();
        }
        Directory directory = (Directory)this.model;
        if (!directory.isOpened()) {
            return Collections.emptyList();
        }
        ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
        for (TreeNode treeNode : this.children) {
            if (!(treeNode instanceof FileTreeNode)) continue;
            arrayList.addAll(((FileTreeNode)treeNode).getOpenedDirectories());
        }
        arrayList.add(this);
        return arrayList;
    }

    public TreeElement getModel() {
        return this.model;
    }

    public String getToolTip() {
        return this.model.getFile().getAbsolutePath();
    }
}

